/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.db.datasource;

import com.ailikes.common.form.base.api.exception.BusinessException;
import com.ailikes.common.form.base.db.datasource.DataSourceException;
import com.ailikes.common.form.base.db.datasource.DbContextHolder;
import java.lang.reflect.Field;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    protected Object determineCurrentLookupKey() {
        return DbContextHolder.getDataSource();
    }

    public void setTargetDataSources(Map<Object, Object> targetDataSources) {
        super.setTargetDataSources(targetDataSources);
        super.afterPropertiesSet();
    }

    public void setDefaultDbtype(String dbType) {
        DbContextHolder.setDataSource("dataSourceDefault", dbType);
    }

    private static Object getValue(Object instance, String fieldName) {
        try {
            Field field = AbstractRoutingDataSource.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    public void addDataSource(String key, Object dataSource) {
        try {
            Map targetDataSources = (Map)DynamicDataSource.getValue((Object)this, "targetDataSources");
            boolean rtn = this.isDataSourceExist(key);
            if (rtn) {
                throw new DataSourceException("datasource name :" + key + "is exists!");
            }
            targetDataSources.put(key, dataSource);
            this.setTargetDataSources(targetDataSources);
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    public boolean isDataSourceExist(String key) {
        try {
            Map targetDataSources = (Map)DynamicDataSource.getValue((Object)this, "targetDataSources");
            return targetDataSources.containsKey(key);
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    public void removeDataSource(String key) {
        Map targetDataSources = (Map)DynamicDataSource.getValue((Object)this, "targetDataSources");
        if (key.equals("dataSource") || key.equals("dataSourceDefault")) {
            throw new DataSourceException("datasource name :" + key + " can't be removed!");
        }
        targetDataSources.remove(key);
        this.setTargetDataSources(targetDataSources);
    }

    public Map<String, DataSource> getDataSource() {
        Map targetDataSources = (Map)DynamicDataSource.getValue((Object)this, "targetDataSources");
        return targetDataSources;
    }
}

