/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.db.datasource;

import com.ailikes.common.form.base.core.util.AppUtil;
import com.ailikes.common.form.base.core.util.StringUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbContextHolder {
    private static final ThreadLocal<String> contextHolderAlias = new ThreadLocal();
    private static Map<String, String> dataSourceDbType = new ConcurrentHashMap<String, String>();
    protected static final Logger LOG = LoggerFactory.getLogger(DbContextHolder.class);

    public static void setDataSource(String dbAlias, String dbType) {
        contextHolderAlias.set(dbAlias);
        dataSourceDbType.put(dbAlias, dbType);
        try {
            SqlSessionFactoryBean sqlSessionFactoryBean = (SqlSessionFactoryBean)AppUtil.getBean(SqlSessionFactoryBean.class);
            if (sqlSessionFactoryBean != null && sqlSessionFactoryBean.getObject() != null && sqlSessionFactoryBean.getObject().getConfiguration() != null) {
                sqlSessionFactoryBean.getObject().getConfiguration().setDatabaseId(dbType);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setDefaultDataSource() {
        contextHolderAlias.set("dataSourceDefault");
    }

    public static String getDataSource() {
        String str = contextHolderAlias.get();
        return str == null ? "dataSourceDefault" : str;
    }

    public static String getDbType() {
        String str;
        String dataSourceAlias = contextHolderAlias.get();
        if (StringUtil.isEmpty((String)dataSourceAlias)) {
            dataSourceAlias = "dataSourceDefault";
        }
        if (StringUtil.isEmpty((String)(str = dataSourceDbType.get(dataSourceAlias)))) {
            LOG.warn("cannot get current dataSourceDbType!");
        }
        return str;
    }

    public static void clearDataSource() {
        contextHolderAlias.remove();
    }

    public static void putDataSourceDbType(String dsKey, String dbType) {
        dataSourceDbType.put(dsKey, dbType);
    }

    public static String getDataSourceDbType(String dsKey) {
        return dataSourceDbType.get(dsKey);
    }
}

