/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.db.datasource;

import com.ailikes.common.form.base.core.util.AppUtil;
import com.ailikes.common.form.base.core.util.StringUtil;
import com.ailikes.common.form.base.db.datasource.DbContextHolder;
import com.ailikes.common.form.base.db.datasource.DynamicDataSource;
import java.util.Map;
import javax.sql.DataSource;

public class DataSourceUtil {
    public static final String GLOBAL_DATASOURCE = "dataSource";
    public static final String DEFAULT_DATASOURCE = "dataSourceDefault";
    public static final String TARGET_DATASOURCES = "targetDataSources";

    public static void addDataSource(String key, DataSource dataSource, boolean replace) {
        DynamicDataSource dynamicDataSource = (DynamicDataSource)((Object)AppUtil.getBean((String)GLOBAL_DATASOURCE));
        if (dynamicDataSource.isDataSourceExist(key)) {
            if (!replace) {
                return;
            }
            dynamicDataSource.removeDataSource(key);
        }
        dynamicDataSource.addDataSource(key, dataSource);
    }

    public static void addDataSource(String key, DataSource dataSource, String dbType, boolean replace) {
        DataSourceUtil.addDataSource(key, dataSource, replace);
        if (StringUtil.isNotEmpty((String)dbType)) {
            DbContextHolder.putDataSourceDbType(key, dbType);
        }
    }

    public static boolean isDataSourceExist(String key) {
        DynamicDataSource dynamicDataSource = (DynamicDataSource)((Object)AppUtil.getBean((String)GLOBAL_DATASOURCE));
        return dynamicDataSource.isDataSourceExist(key);
    }

    public static void removeDataSource(String key) throws IllegalAccessException, NoSuchFieldException {
        DynamicDataSource dynamicDataSource = (DynamicDataSource)((Object)AppUtil.getBean((String)GLOBAL_DATASOURCE));
        dynamicDataSource.removeDataSource(key);
    }

    public static Map<String, DataSource> getDataSources() {
        DynamicDataSource dynamicDataSource = (DynamicDataSource)((Object)AppUtil.getBean((String)GLOBAL_DATASOURCE));
        Map<String, DataSource> map = dynamicDataSource.getDataSource();
        return map;
    }

    public static DataSource getDataSourceByAlias(String alias) {
        Map<String, DataSource> map = DataSourceUtil.getDataSources();
        return map.get(alias);
    }

    public static DataSource getDataSourceByAliasWithLoacl(String alias) {
        DynamicDataSource dynamicDataSource = (DynamicDataSource)((Object)AppUtil.getBean((String)GLOBAL_DATASOURCE));
        if (GLOBAL_DATASOURCE.equals(alias)) {
            return dynamicDataSource;
        }
        return DataSourceUtil.getDataSourceByAlias(alias);
    }
}

