/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.dao.baseinterceptor;

import com.ailikes.common.form.base.api.model.CreateInfoModel;
import com.ailikes.common.form.base.api.model.IDModel;
import com.ailikes.common.form.base.core.id.IdUtil;
import com.ailikes.common.form.base.core.model.BaseModel;
import com.ailikes.common.form.base.core.util.BeanUtils;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class SaveInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        if (BeanUtils.isEmpty((Object)args) || args.length < 2) {
            return invocation.proceed();
        }
        Object param = args[1];
        MappedStatement statement = (MappedStatement)args[0];
        if (statement.getId().endsWith(".update")) {
            if (param instanceof CreateInfoModel) {
                CreateInfoModel model = (CreateInfoModel)param;
                if (model.getUpdateTime() == null) {
                    model.setUpdateTime(new Date());
                }
                if (param instanceof BaseModel) {
                    BaseModel baseModel = (BaseModel)param;
                    baseModel.setVersion(baseModel.getVersion() + 1);
                }
            }
        } else if (StringUtils.endsWithAny((CharSequence)statement.getId(), (CharSequence[])new CharSequence[]{".create", ".insertSelective"})) {
            IDModel model;
            if (param instanceof IDModel && (model = (IDModel)param).getId() == null) {
                model.setId(IdUtil.getSuid());
            }
            if (param instanceof CreateInfoModel) {
                model = (CreateInfoModel)param;
                if (model.getCreateTime() == null) {
                    model.setCreateTime(new Date());
                }
                if (model.getUpdateTime() == null) {
                    model.setUpdateTime(new Date());
                }
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

