/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.dao.baseinterceptor;

import com.ailikes.common.form.base.api.Page;
import com.ailikes.common.form.base.api.query.FieldSort;
import com.ailikes.common.form.base.api.query.QueryFilter;
import com.ailikes.common.form.base.core.util.BeanUtils;
import com.github.pagehelper.PageHelper;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class QueryInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        if (BeanUtils.isEmpty((Object)args) || args.length < 2) {
            return invocation.proceed();
        }
        Object param = args[1];
        if (param instanceof QueryFilter) {
            Map<String, Object> params;
            QueryFilter filter = (QueryFilter)param;
            args[1] = params = this.getQueryParamsByFilter(filter);
            Page page = filter.getPage();
            if (page != null) {
                PageHelper.startPage((int)page.getPageNo(), (int)page.getPageSize(), (boolean)true);
            }
        }
        return invocation.proceed();
    }

    private Map<String, Object> getQueryParamsByFilter(QueryFilter filter) {
        String defaultWhere;
        String dynamicWhereSql = filter.getFieldLogic().getSql();
        Map params = filter.getParams();
        String string = defaultWhere = params.containsKey("defaultWhere") ? params.get("defaultWhere").toString() : "";
        if (StringUtils.isNotEmpty((CharSequence)defaultWhere)) {
            String string2 = dynamicWhereSql = StringUtils.isNotEmpty((CharSequence)dynamicWhereSql) ? dynamicWhereSql + " and " + defaultWhere : defaultWhere;
        }
        if (StringUtils.isNotEmpty((CharSequence)dynamicWhereSql)) {
            params.put("whereSql", dynamicWhereSql);
        }
        if (filter.getFieldSortList().size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (FieldSort fieldSort : filter.getFieldSortList()) {
                sb.append(fieldSort.getField()).append(" ").append(fieldSort.getDirection()).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            params.put("orderBySql", sb.toString());
        }
        return params;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

