/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.form.base.dao;

import com.ailikes.common.form.base.api.Page;
import com.ailikes.common.form.base.api.query.QueryFilter;
import com.ailikes.common.form.base.db.model.query.DefaultQueryFilter;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

@Repository
public class CommonDao<T> {
    @Resource(name="abSqlSessionTemplate")
    protected SqlSessionTemplate sqlSessionTemplate;
    private static final String NAME_SPACE = "com.ailikes.common.form.sql.common";

    public void execute(String sql) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sql", sql);
        String key = this.getNameSpace("execute");
        this.sqlSessionTemplate.update(key, map);
    }

    public List<T> query(String sql) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sql", sql);
        String key = this.getNameSpace("query");
        return this.sqlSessionTemplate.selectList(key, map);
    }

    public List<T> query(String sql, Page page) {
        DefaultQueryFilter query = new DefaultQueryFilter();
        query.addParamsFilter("sql", sql);
        query.setPage(page);
        String key = this.getNameSpace("query");
        return this.sqlSessionTemplate.selectList(key, (Object)query);
    }

    private String getNameSpace(String sqlKey) {
        return "com.ailikes.common.form.sql.common." + sqlKey;
    }

    public List<T> queryForListPage(String sql, QueryFilter queryFilter) {
        Assert.notNull((Object)sql);
        queryFilter.addParamsFilter("sql", (Object)sql);
        return this.sqlSessionTemplate.selectList(this.getNameSpace("queryFormList"), (Object)queryFilter);
    }
}

