/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.disruptor;

import com.ailikes.common.disruptor.Task;
import com.ailikes.common.disruptor.TaskEvent;
import com.ailikes.common.disruptor.TaskEventFactory;
import com.ailikes.common.disruptor.TaskEventProducer;
import com.ailikes.common.disruptor.TaskHandler;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.IgnoreExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;

public class TaskHelper {
    private int handlerCount = 1;
    private int bufferSize = 1024;
    private Disruptor<TaskEvent> disruptor;
    private TaskEventProducer taskEventProducer;

    public TaskHelper() {
    }

    public TaskHelper(int handlerCount, int bufferSize) {
        this.handlerCount = handlerCount;
        this.bufferSize = bufferSize;
    }

    @PostConstruct
    private void start() {
        ExecutorService executor = Executors.newCachedThreadPool();
        TaskEventFactory factory = new TaskEventFactory();
        this.disruptor = new Disruptor((EventFactory)factory, this.bufferSize, (Executor)executor, ProducerType.SINGLE, (WaitStrategy)new BlockingWaitStrategy());
        ArrayList<TaskHandler> TaskHandlers = new ArrayList<TaskHandler>();
        for (int i = 0; i < this.handlerCount; ++i) {
            TaskHandlers.add(new TaskHandler());
        }
        this.disruptor.handleExceptionsWith((ExceptionHandler)new IgnoreExceptionHandler());
        this.disruptor.handleEventsWithWorkerPool((WorkHandler[])TaskHandlers.toArray(new TaskHandler[TaskHandlers.size()]));
        this.disruptor.start();
        RingBuffer ringBuffer = this.disruptor.getRingBuffer();
        this.taskEventProducer = new TaskEventProducer((RingBuffer<TaskEvent>)ringBuffer);
    }

    public void shutdown() {
        this.doHalt();
    }

    private void doHalt() {
        this.disruptor.halt();
    }

    public void doTask(Task task) {
        this.taskEventProducer.doTask(task);
    }

    public int getHandlerCount() {
        return this.handlerCount;
    }

    public void setHandlerCount(int handlerCount) {
        this.handlerCount = handlerCount;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }
}

