/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.listener;

import com.ailikes.common.listener.data.ApplicationInitable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class ApplicationContextListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static Logger _log = LoggerFactory.getLogger(ApplicationContextListener.class);

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        if (null == contextRefreshedEvent.getApplicationContext().getParent()) {
            _log.debug(">>>>> spring\u521d\u59cb\u5316\u5f00\u59cb <<<<<");
            Map baseInterfaceBeans = contextRefreshedEvent.getApplicationContext().getBeansOfType(ApplicationInitable.class);
            for (ApplicationInitable applicationInitable : baseInterfaceBeans.values()) {
                _log.debug(">>>>> {}.init()", (Object)applicationInitable.getClass().getName());
                try {
                    applicationInitable.init();
                }
                catch (Exception e) {
                    _log.error("\u521d\u59cb\u5316ApplicationInitable\u7684init\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
                    e.printStackTrace();
                }
            }
        }
    }
}

