/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.mvc.entity.tree;

import com.ailikes.common.mvc.entity.tree.BootstrapTreeNode;
import com.ailikes.common.mvc.entity.tree.TreeNode;
import com.ailikes.common.utils.ObjectUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BootstrapTreeHelper<ID extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 2444638065060902858L;
    private List<TreeNode<ID>> treeNodes;

    public static <T extends Serializable> BootstrapTreeHelper<T> create() {
        BootstrapTreeHelper treeSortUtil = new BootstrapTreeHelper();
        return treeSortUtil;
    }

    public List<BootstrapTreeNode> getTopNodes() {
        ArrayList<BootstrapTreeNode> list = new ArrayList<BootstrapTreeNode>();
        for (TreeNode<ID> treeable : this.treeNodes) {
            if (!treeable.isRoot()) continue;
            list.add(new BootstrapTreeNode(treeable));
        }
        return list;
    }

    public void parseSubNode(BootstrapTreeNode node) {
        ArrayList<BootstrapTreeNode> newTreeNodes = new ArrayList<BootstrapTreeNode>();
        for (TreeNode<ID> treeable : this.treeNodes) {
            if (ObjectUtils.isNullOrEmpty(treeable.getParentId()) || !((Serializable)treeable.getParentId()).equals(node.getHref())) continue;
            BootstrapTreeNode bootstrapTreeNode = new BootstrapTreeNode(treeable);
            newTreeNodes.add(bootstrapTreeNode);
            this.parseSubNode(bootstrapTreeNode);
            node.setNodes(newTreeNodes);
        }
    }

    public List<BootstrapTreeNode> sort(List<?> treeNodes) {
        this.treeNodes = treeNodes;
        List<BootstrapTreeNode> rootNodes = this.getTopNodes();
        for (BootstrapTreeNode rootNode : rootNodes) {
            this.parseSubNode(rootNode);
        }
        this.treeNodes.clear();
        return rootNodes;
    }
}

