// 'use strict';
//
var activitiIndexApp = angular.module('activitiIndexApp', [
    'mgcrea.ngStrap',
    'ngGrid',
]);
activitiIndexApp.controller('gridCtrl', ['$rootScope','$scope','$http','$location','$modal', '$timeout', function($rootScope,$scope,$http,$location,$modal,$timeout){
    $scope.edit={
        url:"activiti/createModel"
    };
    /** 设计流程 */
    $scope.createModel = function(){
        var opts = {
            template:  'modeler-designer.html',
            scope: $scope
        };
        // Open the dialog
        top.window.designerModal =  $modal(opts);
            // var modelId = entity.id;
            // $http.get("./activiti/editModel",{modelId:modelId}).success(function(result) {
            //     swal("删除成功!", "", "success");
            // });
    }
    /** 设计流程 */
    $scope.editModel = function(entity){
        $scope.edit.url="modeler.html?modelId="+entity.id
        var opts = {
            template:  'modeler-designer.html',
            scope: $scope
        };
        // Open the dialog
        top.window.designerModal =  $modal(opts);
            // var modelId = entity.id;
            // $http.get("./activiti/editModel",{modelId:modelId}).success(function(result) {
            //     swal("删除成功!", "", "success");
            // });
    }
    /** 部署流程 */
    $scope.deployModel = function(entity){
        if (confirm("确定部署该流程？")) {
            var modelId = entity.id;
            $http.post("./activiti/deployModel",{modelId:modelId}).success(function(result) {
                if(result.success){
                    swal(result.msg, "", "success");
                }else{
                    swal(result.msg, "", "error");
                }
            });
        }else {
            alert("点击了取消");
        }
    }
    /** 导出流程 */
    $scope.exportModel = function(entity){
            var modelId = entity.id;
            window.open("./activiti/exportModel/"+modelId)
    }
    /** 删除流程 */
    $scope.deleteModel = function(entity){
        if (confirm("确定删除该流程？")) {
            var modelId = entity.id;
            $http.post("./activiti/deleteModel",{modelId:modelId}).success(function(result) {
                if(result.success){
                    swal(result.msg, "", "success");
                }else{
                    swal(result.msg, "", "error");
                }
            });
        }
    }

    // $http.post("./activiti/modelList").success(function(result) {
    //     $scope.modelList=result;
    // });

    $scope.modelList = [];
    $scope.filterOptions = {
        filterText: "",
        useExternalFilter: true
    };

    $scope.totalServerItems = 0;
    $scope.pagingOptions = {
        pageSizes:   [10, 20,50,100,200,500, 1000],  // page size options
        pageSize:    10,              // default page size
        currentPage: 1                 // initial page
    };

    $scope.setPagingData = function(data, page, pageSize){
        // calc for pager
        var pagedData = data.slice((page - 1) * pageSize, page * pageSize);
        // Store data from server
        $scope.modelList = pagedData;
        // Update server side data length
        $scope.totalServerItems = data.length;
        if (!$scope.$$phase) {
            $scope.$apply();
        }
    };

    $scope.getPagedDataAsync = function (pageSize, page, searchText) {
        var ngGridResourcePath = './activiti/modelList';
        $timeout(function () {
            if (searchText) {
                var ft = searchText.toLowerCase();
                $http.post(ngGridResourcePath).success(function (largeLoad) {
                    var data = largeLoad.filter(function(item) {
                        return JSON.stringify(item).toLowerCase().indexOf(ft) != -1;
                    });
                    $scope.setPagingData(data,page,pageSize);
                });
            } else {
                $http.post(ngGridResourcePath).success(function (largeLoad) {
                    $scope.setPagingData(largeLoad,page,pageSize);
                });
            }
        }, 100);
    };


    $scope.$watch('pagingOptions', function (newVal, oldVal) {
        if (newVal !== oldVal && newVal.currentPage !== oldVal.currentPage) {
            $scope.getPagedDataAsync($scope.pagingOptions.pageSize, $scope.pagingOptions.currentPage, $scope.filterOptions.filterText);
        }
    }, true);
    $scope.$watch('filterOptions', function (newVal, oldVal) {
        if (newVal !== oldVal) {
            $scope.getPagedDataAsync($scope.pagingOptions.pageSize, $scope.pagingOptions.currentPage, $scope.filterOptions.filterText);
        }
    }, true);

    $scope.getPagedDataAsync($scope.pagingOptions.pageSize, $scope.pagingOptions.currentPage);
    var editBtn = '<button type="button" class="mb-sm btn btn-primary" href="javascrtpt:void(0);" data-id="{{row.entity.id}}" ng-click="editModel(row.entity)">设计流程</button>';
    var exportBtn = '<button type="button" class="mb-sm btn btn-success" href="javascrtpt:void(0);" data-id="{{row.entity.id}}" ng-click="exportModel(row.entity)">导出流程</button>';
    var deployBtn = '<button type="button" class="mb-sm btn btn-success" href="javascrtpt:void(0);" data-id="{{row.entity.id}}" ng-click="deployModel(row.entity)">部署流程</button>';
    var delBtn = '<button type="button" class="mb-sm btn btn-danger" href="javascrtpt:void(0);" data-id="{{row.entity.id}}" ng-click="deleteModel(row.entity)">删除流程</button>';
    var buttonHtml = editBtn + deployBtn + exportBtn + delBtn;
    $scope.gridOptions = {
        data: 'modelList',
        multiSelect: false,
        enablePaging:     true,
        showFooter:       true,
        showColumnMenu : true,
        enableGridMenu: true,
        rowHeight:        36,
        headerRowHeight:  38,
        totalServerItems: 'totalServerItems',
        pagingOptions:    $scope.pagingOptions,
        filterOptions:    $scope.filterOptions,
        columnDefs: [{
                field: 'id',
                displayName: 'ID',
                sortable: true,
                visible:false
            },{
                field: 'name',
                displayName: '模型名称',
                sortable: true
            },{
                field: 'key',
                displayName: '模型标识',
                sortable: true
            },{
                field: 'category',
                displayName: '分类',
                sortable: true
            },{
                field: 'createTime',
                displayName: '创建时间',
                enableColumnMenu: true,// 是否显示列头部菜单按钮
                sortable: true,
                visible:false,
            },{
                field: 'version',
                displayName: '版本',
                sortable: true
            }
            ,{
                field: 'revision',
                displayName: '乐观锁',
                sortable: true,
                visible:false
            }
            ,{
                field: 'deploymentId',
                displayName: '部署ID',
                sortable: true,
                visible:false
            }
            ,{
                field: 'metaInfo',
                displayName: '描述',
                sortable: true,
                visible:false
            }
            ,{
                field: 'editorSourceValueId',
                displayName: '资源值ID',
                sortable: true,
                visible:false
            }
            ,{
                field: 'editorSourceExtraValueId',
                displayName: '资源额外值ID',
                sortable: true,
                visible:false
            }
            ,{
                field: 'id',
                displayName: '操作',
                sortable: true,
                cellTemplate:buttonHtml
            }
        ]
    };
}]).config(function ($httpProvider) {
    $httpProvider.defaults.transformRequest = function (obj) {
        var str = [];
        for (var p in obj) {
            str.push(encodeURIComponent(p) + "=" + encodeURIComponent(obj[p]));
        }
        return str.join("&");
    };
    $httpProvider.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded; charset=utf-8';
});