/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.activiti.controller;

import com.ailikes.common.core.web.response.R;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/activiti"})
@Api(value="\u5de5\u4f5c\u6d41\u6a21\u578b\u7ba1\u7406")
public class ActivitiModelController {
    private static final Logger log = LoggerFactory.getLogger(ActivitiModelController.class);
    @Autowired
    ProcessEngine processEngine;
    @Autowired
    ObjectMapper objectMapper;

    @RequestMapping(value={"/createModel"}, method={RequestMethod.GET})
    public void createModel(HttpServletResponse response) throws IOException {
        RepositoryService repositoryService = this.processEngine.getRepositoryService();
        Model model = repositoryService.newModel();
        String name = "new-process";
        String description = "";
        int revision = 1;
        String key = "process";
        ObjectNode modelNode = this.objectMapper.createObjectNode();
        modelNode.put("name", name);
        modelNode.put("description", description);
        modelNode.put("revision", revision);
        model.setName(name);
        model.setKey(key);
        model.setMetaInfo(modelNode.toString());
        repositoryService.saveModel(model);
        String id = model.getId();
        ObjectNode editorNode = this.objectMapper.createObjectNode();
        editorNode.put("id", "canvas");
        editorNode.put("resourceId", "canvas");
        ObjectNode stencilSetNode = this.objectMapper.createObjectNode();
        stencilSetNode.put("namespace", "http://b3mn.org/stencilset/bpmn2.0#");
        editorNode.put("stencilset", (JsonNode)stencilSetNode);
        repositoryService.addModelEditorSource(id, editorNode.toString().getBytes("utf-8"));
        response.sendRedirect("/static/modeler.html" + id);
    }

    @RequestMapping(value={"/deleteModel"}, method={RequestMethod.POST})
    @ResponseBody
    public R deleteModel(String modelId) throws IOException {
        try {
            RepositoryService repositoryService = this.processEngine.getRepositoryService();
            repositoryService.deleteModel(modelId);
            return R.ok((String)"\u6d41\u7a0b\u5220\u9664\u6210\u529f");
        }
        catch (Exception exception) {
            return R.error((String)"\u6d41\u7a0b\u5220\u9664\u5931\u8d25");
        }
    }

    @RequestMapping(value={"/deployModel"}, method={RequestMethod.POST})
    @ResponseBody
    public R deployModel(String modelId) throws Exception {
        Model modelData;
        RepositoryService repositoryService = this.processEngine.getRepositoryService();
        byte[] bytes = repositoryService.getModelEditorSource((modelData = repositoryService.getModel(modelId)).getId());
        if (bytes == null) {
            return R.error((String)"\u6d41\u7a0b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u8ba1\u6d41\u7a0b\u5e76\u6210\u529f\u4fdd\u5b58\uff0c\u518d\u8fdb\u884c\u53d1\u5e03\u3002");
        }
        JsonNode modelNode = new ObjectMapper().readTree(bytes);
        BpmnModel model = new BpmnJsonConverter().convertToBpmnModel(modelNode);
        if (model.getProcesses().size() == 0) {
            return R.error((String)"\u6570\u636e\u6d41\u7a0b\u4e0d\u7b26\u8981\u6c42\uff0c\u8bf7\u81f3\u5c11\u8bbe\u8ba1\u4e00\u6761\u4e3b\u7ebf\u6d41\u7a0b\u3002");
        }
        byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(model);
        String processName = modelData.getName() + ".bpmn20.xml";
        Deployment deployment = repositoryService.createDeployment().name(modelData.getName()).addString(processName, new String(bpmnBytes, "UTF-8")).deploy();
        modelData.setDeploymentId(deployment.getId());
        repositoryService.saveModel(modelData);
        return R.ok((String)"\u90e8\u7f72\u6210\u529f");
    }

    @RequestMapping(value={"/editModel"}, method={RequestMethod.GET})
    public void editModel(HttpServletResponse response, String modelId) throws IOException {
        RepositoryService repositoryService = this.processEngine.getRepositoryService();
        response.sendRedirect("/static/modeler.html" + modelId);
    }

    @RequestMapping(value={"exportModel/{modelId}"}, method={RequestMethod.GET})
    public void exportModel(@PathVariable(value="modelId") String modelId, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        RepositoryService repositoryService = this.processEngine.getRepositoryService();
        try {
            Model modelData = repositoryService.getModel(modelId);
            BpmnJsonConverter jsonConverter = new BpmnJsonConverter();
            byte[] arg0 = repositoryService.getModelEditorSource(modelData.getId());
            JsonNode editorNode = new ObjectMapper().readTree(arg0);
            BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(editorNode);
            BpmnXMLConverter xmlConverter = new BpmnXMLConverter();
            byte[] bpmnBytes = xmlConverter.convertToXML(bpmnModel);
            ByteArrayInputStream in = new ByteArrayInputStream(bpmnBytes);
            IOUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
            String filename = modelData.getName() + ".bpmn";
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(filename, "UTF-8"));
            response.flushBuffer();
        }
        catch (Exception e) {
            PrintWriter out = null;
            try {
                out = response.getWriter();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            out.write("\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/modelList"}, method={RequestMethod.POST})
    @ResponseBody
    public Object modelList() {
        RepositoryService repositoryService = this.processEngine.getRepositoryService();
        return repositoryService.createModelQuery().list();
    }

    @RequestMapping(value={"/start"}, method={RequestMethod.POST})
    @ResponseBody
    public R startProcess(String keyName) {
        ProcessInstance process = this.processEngine.getRuntimeService().startProcessInstanceByKey(keyName);
        return R.ok().put("processId", process.getId() + " : " + process.getProcessDefinitionId());
    }
}

