/*
 * Decompiled with CFR 0.152.
 */
package com.ailikes.common.activiti.config;

import com.ailikes.common.activiti.ext.ActivitiExtendProperties;
import com.ailikes.common.activiti.util.IdGen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.interceptor.SessionFactory;
import org.activiti.spring.SpringProcessEngineConfiguration;
import org.activiti.spring.boot.ProcessEngineConfigurationConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ComponentScan(value={"com.ailikes.common", "org.activiti.rest.diagram", "org.activiti.rest.editor"})
@EnableConfigurationProperties(value={ActivitiExtendProperties.class})
@EnableWebSecurity
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class ActivitiConfig
extends WebSecurityConfigurerAdapter
implements WebMvcConfigurer {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ActivitiExtendProperties properties;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/modeler-list.html"}).addResourceLocations(new String[]{"classpath:/static/"});
        registry.addResourceHandler(new String[]{"/modeler-designer.html"}).addResourceLocations(new String[]{"classpath:/static/"});
        registry.addResourceHandler(new String[]{"/modeler.html"}).addResourceLocations(new String[]{"classpath:/static/"});
        registry.addResourceHandler(new String[]{"/diagram-viewer/**"}).addResourceLocations(new String[]{"classpath:/static/diagram-viewer/"});
        registry.addResourceHandler(new String[]{"/editor-app/**"}).addResourceLocations(new String[]{"classpath:/static/editor-app/"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().antMatchers(new String[]{"/model/**"})).permitAll();
        http.headers().frameOptions().disable();
    }

    @Bean
    public ProcessEngineConfigurationConfigurer processEngineConfigurationConfigurer(final IdGen idGen) {
        ProcessEngineConfigurationConfigurer configurer = new ProcessEngineConfigurationConfigurer(){

            public void configure(SpringProcessEngineConfiguration processEngineConfiguration) {
                processEngineConfiguration.setActivityFontName(ActivitiConfig.this.properties.getActivityFontName());
                processEngineConfiguration.setLabelFontName(ActivitiConfig.this.properties.getLabelFontName());
                processEngineConfiguration.setCustomSessionFactories(ActivitiConfig.this.getCustomSessionFactories());
                processEngineConfiguration.setBeans(ActivitiConfig.this.getBeans());
                processEngineConfiguration.setIdGenerator((IdGenerator)idGen);
                processEngineConfiguration.setDatabaseSchemaUpdate(ActivitiConfig.this.properties.getDatabaseSchemaUpdate());
            }
        };
        return configurer;
    }

    private Map<Object, Object> getBeans() {
        HashMap<Object, Object> beans = new HashMap<Object, Object>();
        return beans;
    }

    private List<SessionFactory> getCustomSessionFactories() {
        ArrayList<SessionFactory> sessionFactoryList = new ArrayList<SessionFactory>();
        return sessionFactoryList;
    }
}

