/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.server.service;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Objects;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.commons.random.RandomUtil;
import net.guerlab.sms.core.domain.NoticeData;
import net.guerlab.sms.core.exception.PhoneIsNullException;
import net.guerlab.sms.core.exception.RetryTimeShortException;
import net.guerlab.sms.server.entity.VerificationCode;
import net.guerlab.sms.server.properties.SmsProperties;
import net.guerlab.sms.server.repository.IVerificationCodeRepository;
import net.guerlab.sms.server.service.ICodeGenerate;
import net.guerlab.sms.server.service.NoticeService;
import net.guerlab.sms.server.service.VerificationCodeService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultVerificationCodeService
implements VerificationCodeService {
    @Autowired
    private IVerificationCodeRepository repository;
    @Autowired
    private SmsProperties properties;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private ICodeGenerate codeGenerate;

    @Override
    public String find(String phone, String identificationCode) {
        if (StringUtils.isBlank((CharSequence)phone)) {
            return null;
        }
        this.phoneValidation(phone);
        VerificationCode verificationCode = this.repository.findOne(phone, identificationCode);
        return verificationCode == null ? null : verificationCode.getCode();
    }

    private String createIdentificationCode() {
        if (!this.properties.getVerificationCode().isUseIdentificationCode()) {
            return "";
        }
        return RandomUtil.nextString((int)this.properties.getVerificationCode().getIdentificationCodeLength());
    }

    @Override
    public void send(String phone) {
        if (StringUtils.isBlank((CharSequence)phone)) {
            throw new PhoneIsNullException();
        }
        String identificationCode = this.createIdentificationCode();
        this.phoneValidation(phone);
        VerificationCode verificationCode = this.repository.findOne(phone, identificationCode);
        boolean newVerificationCode = false;
        if (verificationCode == null) {
            verificationCode = new VerificationCode();
            verificationCode.setPhone(phone);
            verificationCode.setIdentificationCode(identificationCode);
            Long expirationTime = this.properties.getVerificationCode().getExpirationTime();
            Long retryIntervalTime = this.properties.getVerificationCode().getRetryIntervalTime();
            if (NumberHelper.greaterZero((Number)expirationTime)) {
                verificationCode.setExpirationTime(LocalDateTime.now().plusSeconds(expirationTime));
            }
            if (NumberHelper.greaterZero((Number)retryIntervalTime)) {
                verificationCode.setRetryTime(LocalDateTime.now().plusSeconds(retryIntervalTime));
            }
            verificationCode.setCode(this.codeGenerate.generate());
            newVerificationCode = true;
        } else {
            long surplus;
            LocalDateTime retryTime = verificationCode.getRetryTime();
            if (retryTime != null && (surplus = retryTime.toEpochSecond(ZoneOffset.UTC) - LocalDateTime.now().toEpochSecond(ZoneOffset.UTC)) > 0L) {
                throw new RetryTimeShortException(surplus);
            }
        }
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("code", verificationCode.getCode());
        params.put("identificationCode", verificationCode.getIdentificationCode());
        NoticeData notice = new NoticeData();
        notice.setType("VerificationCode");
        notice.setParams(params);
        if (this.noticeService.send(notice, phone) && newVerificationCode) {
            this.repository.save(verificationCode);
        }
    }

    @Override
    public boolean verify(String phone, String code, String identificationCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{phone, code})) {
            return false;
        }
        this.phoneValidation(phone);
        VerificationCode verificationCode = this.repository.findOne(phone, identificationCode);
        if (verificationCode == null) {
            return false;
        }
        boolean verifyData = Objects.equals(verificationCode.getCode(), code);
        if (verifyData && this.properties.getVerificationCode().isDeleteByVerifySucceed()) {
            this.repository.delete(phone, identificationCode);
        }
        if (!verifyData && this.properties.getVerificationCode().isDeleteByVerifyFail()) {
            this.repository.delete(phone, identificationCode);
        }
        return verifyData;
    }

    private void phoneValidation(String phone) {
        if (!this.noticeService.phoneRegValidation(phone)) {
            throw new PhoneIsNullException();
        }
    }
}

