/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.server.repository;

import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.guerlab.sms.server.entity.VerificationCode;
import net.guerlab.sms.server.repository.IVerificationCodeRepository;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerificationCodeMemoryRepository
implements IVerificationCodeRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(VerificationCodeMemoryRepository.class);
    private Map<String, VerificationCode> cache = new ConcurrentHashMap<String, VerificationCode>();

    @Override
    public VerificationCode findOne(String phone, String identificationCode) {
        String key = this.key(phone, identificationCode);
        VerificationCode verificationCode = this.cache.get(key);
        if (verificationCode == null) {
            LOGGER.debug("verificationCode is null");
            return null;
        }
        LocalDateTime expirationTime = verificationCode.getExpirationTime();
        if (expirationTime != null && expirationTime.isBefore(LocalDateTime.now())) {
            LOGGER.debug("verificationCode is not null, but timeout");
            this.cache.remove(key);
            return null;
        }
        return verificationCode;
    }

    @Override
    public void save(VerificationCode verificationCode) {
        String key = this.key(verificationCode.getPhone(), verificationCode.getIdentificationCode());
        this.cache.put(key, verificationCode);
    }

    @Override
    public void delete(String phone, String identificationCode) {
        this.cache.remove(this.key(phone, identificationCode));
    }

    private String key(String phone, String identificationCode) {
        if (StringUtils.isBlank((CharSequence)identificationCode)) {
            return phone;
        }
        return phone + "_" + identificationCode;
    }
}

