/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.server.controller;

import net.guerlab.sms.core.domain.NoticeInfo;
import net.guerlab.sms.core.domain.VerifyInfo;
import net.guerlab.sms.core.exception.VerificationCodeIsNullException;
import net.guerlab.sms.core.exception.VerifyFailException;
import net.guerlab.sms.server.service.NoticeService;
import net.guerlab.sms.server.service.VerificationCodeService;
import net.guerlab.web.result.Result;
import net.guerlab.web.result.Succeed;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SmsController {
    @Autowired
    private VerificationCodeService verificationCodeService;
    @Autowired
    private NoticeService noticeService;

    public void sendVerificationCode(@PathVariable(value="phone") String phone) {
        this.verificationCodeService.send(phone);
    }

    public Result<String> getVerificationCode(@PathVariable(value="phone") String phone, @RequestParam(value="identificationCode", required=false, defaultValue="") String identificationCode) {
        String code = this.verificationCodeService.find(phone, identificationCode);
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new VerificationCodeIsNullException();
        }
        return new Succeed("success", (Object)code);
    }

    public void verifyVerificationCode(@RequestBody VerifyInfo verifyInfo) {
        if (!this.verificationCodeService.verify(verifyInfo.getPhone(), verifyInfo.getCode(), verifyInfo.getIdentificationCode())) {
            throw new VerifyFailException();
        }
    }

    public void sendNotice(@RequestBody NoticeInfo info) {
        this.noticeService.send(info.getNoticeData(), info.getPhones());
    }
}

