/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch;

import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import zipkin2.elasticsearch.BodyConverters;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.elasticsearch.internal.client.HttpCall;

final class EnsureIndexTemplate {
    EnsureIndexTemplate() {
    }

    static void apply(HttpCall.Factory callFactory, String name, String indexTemplate) throws IOException {
        HttpUrl templateUrl = callFactory.baseUrl.newBuilder("_template").addPathSegment(name).build();
        Request getTemplate = new Request.Builder().url(templateUrl).tag((Object)"get-template").build();
        try {
            callFactory.newCall(getTemplate, BodyConverters.NULL).execute();
        }
        catch (IllegalStateException e) {
            Request updateTemplate = new Request.Builder().url(templateUrl).put(RequestBody.create((MediaType)ElasticsearchStorage.APPLICATION_JSON, (String)indexTemplate)).tag((Object)"update-template").build();
            callFactory.newCall(updateTemplate, BodyConverters.NULL).execute();
        }
    }
}

