/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.elasticsearch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import okio.BufferedSource;
import zipkin2.Call;
import zipkin2.DependencyLink;
import zipkin2.Span;
import zipkin2.elasticsearch.BodyConverters;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.elasticsearch.internal.IndexNameFormatter;
import zipkin2.elasticsearch.internal.client.Aggregation;
import zipkin2.elasticsearch.internal.client.HttpCall;
import zipkin2.elasticsearch.internal.client.SearchCallFactory;
import zipkin2.elasticsearch.internal.client.SearchRequest;
import zipkin2.storage.QueryRequest;
import zipkin2.storage.SpanStore;

final class ElasticsearchSpanStore
implements SpanStore {
    static final String SPAN = "span";
    static final String DEPENDENCY = "dependency";
    static final long EARLIEST_MS = 1456790400000L;
    final SearchCallFactory search;
    final String[] allSpanIndices;
    final IndexNameFormatter indexNameFormatter;
    final boolean strictTraceId;
    final boolean searchEnabled;
    final int namesLookback;

    ElasticsearchSpanStore(ElasticsearchStorage es) {
        this.search = new SearchCallFactory(es.http());
        this.allSpanIndices = new String[]{es.indexNameFormatter().formatType(SPAN)};
        this.indexNameFormatter = es.indexNameFormatter();
        this.strictTraceId = es.strictTraceId();
        this.searchEnabled = es.searchEnabled();
        this.namesLookback = es.namesLookback();
    }

    public Call<List<List<Span>>> getTraces(final QueryRequest request) {
        if (!this.searchEnabled) {
            return Call.emptyList();
        }
        long endMillis = request.endTs();
        long beginMillis = Math.max(endMillis - request.lookback(), 1456790400000L);
        SearchRequest.Filters filters = new SearchRequest.Filters();
        filters.addRange("timestamp_millis", beginMillis, endMillis);
        if (request.serviceName() != null) {
            filters.addTerm("localEndpoint.serviceName", request.serviceName());
        }
        if (request.spanName() != null) {
            filters.addTerm("name", request.spanName());
        }
        for (Map.Entry kv : request.annotationQuery().entrySet()) {
            if (((String)kv.getValue()).isEmpty()) {
                filters.addTerm("_q", (String)kv.getKey());
                continue;
            }
            filters.addTerm("_q", (String)kv.getKey() + "=" + (String)kv.getValue());
        }
        if (request.minDuration() != null) {
            filters.addRange("duration", request.minDuration(), request.maxDuration());
        }
        Aggregation traceIdTimestamp = Aggregation.terms("traceId", request.limit()).addSubAggregation(Aggregation.min("timestamp_millis")).orderBy("timestamp_millis", "desc");
        final List<String> indices = this.indexNameFormatter.formatTypeAndRange(SPAN, beginMillis, endMillis);
        if (indices.isEmpty()) {
            return Call.emptyList();
        }
        SearchRequest esRequest = SearchRequest.create(indices).filters(filters).addAggregation(traceIdTimestamp);
        HttpCall<List<String>> traceIdsCall = this.search.newCall(esRequest, BodyConverters.KEYS);
        final HttpCall.BodyConverter<List<List<Span>>> converter = new HttpCall.BodyConverter<List<List<Span>>>(){

            @Override
            public List<List<Span>> convert(BufferedSource content) throws IOException {
                List<Span> input = BodyConverters.SPANS.convert(content);
                List<List<Span>> traces = ElasticsearchSpanStore.groupByTraceId(input, ElasticsearchSpanStore.this.strictTraceId);
                if (ElasticsearchSpanStore.this.strictTraceId) {
                    return traces;
                }
                Iterator<List<Span>> trace = traces.iterator();
                while (trace.hasNext()) {
                    List<Span> next = trace.next();
                    if (next.get(0).traceId().length() <= 16 || request.test(next)) continue;
                    trace.remove();
                }
                return traces;
            }
        };
        return traceIdsCall.flatMap((Call.FlatMapper)new Call.FlatMapper<List<String>, List<List<Span>>>(){

            public Call<List<List<Span>>> map(List<String> input) {
                if (input.isEmpty()) {
                    return Call.emptyList();
                }
                SearchRequest getTraces = SearchRequest.create(indices).terms("traceId", input);
                return ElasticsearchSpanStore.this.search.newCall(getTraces, converter);
            }
        });
    }

    public Call<List<Span>> getTrace(String traceId) {
        traceId = Span.normalizeTraceId((String)traceId);
        if (!this.strictTraceId && traceId.length() == 32) {
            traceId = traceId.substring(16);
        }
        SearchRequest request = SearchRequest.create(Arrays.asList(this.allSpanIndices)).term("traceId", traceId);
        return this.search.newCall(request, BodyConverters.SPANS);
    }

    public Call<List<String>> getServiceNames() {
        if (!this.searchEnabled) {
            return Call.emptyList();
        }
        long endMillis = System.currentTimeMillis();
        long beginMillis = endMillis - (long)this.namesLookback;
        List<String> indices = this.indexNameFormatter.formatTypeAndRange(SPAN, beginMillis, endMillis);
        if (indices.isEmpty()) {
            return Call.emptyList();
        }
        SearchRequest.Filters filters = new SearchRequest.Filters();
        filters.addRange("timestamp_millis", beginMillis, endMillis);
        SearchRequest request = SearchRequest.create(indices).filters(filters).addAggregation(Aggregation.terms("localEndpoint.serviceName", Integer.MAX_VALUE)).addAggregation(Aggregation.terms("remoteEndpoint.serviceName", Integer.MAX_VALUE));
        return this.search.newCall(request, BodyConverters.KEYS);
    }

    public Call<List<String>> getSpanNames(String serviceName) {
        if (!this.searchEnabled) {
            return Call.emptyList();
        }
        if ("".equals(serviceName)) {
            return Call.emptyList();
        }
        long endMillis = System.currentTimeMillis();
        long beginMillis = endMillis - (long)this.namesLookback;
        List<String> indices = this.indexNameFormatter.formatTypeAndRange(SPAN, beginMillis, endMillis);
        if (indices.isEmpty()) {
            return Call.emptyList();
        }
        SearchRequest.Filters filters = new SearchRequest.Filters().addRange("timestamp_millis", beginMillis, endMillis).addTerm("localEndpoint.serviceName", serviceName.toLowerCase(Locale.ROOT));
        SearchRequest request = SearchRequest.create(indices).filters(filters).addAggregation(Aggregation.terms("name", Integer.MAX_VALUE));
        return this.search.newCall(request, BodyConverters.KEYS);
    }

    public Call<List<DependencyLink>> getDependencies(long endTs, long lookback) {
        long beginMillis = Math.max(endTs - lookback, 1456790400000L);
        List<String> indices = this.indexNameFormatter.formatTypeAndRange(DEPENDENCY, beginMillis, endTs);
        if (indices.isEmpty()) {
            return Call.emptyList();
        }
        return this.search.newCall(SearchRequest.create(indices), BodyConverters.DEPENDENCY_LINKS);
    }

    static List<List<Span>> groupByTraceId(Collection<Span> input, boolean strictTraceId) {
        if (input.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashMap groupedByTraceId = new LinkedHashMap();
        for (Span span : input) {
            String traceId;
            String string = traceId = strictTraceId || span.traceId().length() == 16 ? span.traceId() : span.traceId().substring(16);
            if (!groupedByTraceId.containsKey(traceId)) {
                groupedByTraceId.put(traceId, new ArrayList());
            }
            ((List)groupedByTraceId.get(traceId)).add(span);
        }
        return new ArrayList<List<Span>>(groupedByTraceId.values());
    }
}

