/*
 * Decompiled with CFR 0.152.
 */
package com.jpay.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang3.StringEscapeUtils;

public final class StringUtils
extends org.apache.commons.lang3.StringUtils {
    private static final String _INT = "0123456789";
    private static final String _STR = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String _ALL = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final Random RANDOM = new Random();

    public static String encode(String str) {
        String encode = null;
        try {
            encode = URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encode;
    }

    public static String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String getOutTradeNo() {
        SimpleDateFormat format = new SimpleDateFormat("MMddHHmmss", Locale.getDefault());
        Date date = new Date();
        String key = format.format(date);
        key = key + System.currentTimeMillis();
        key = key.substring(0, 15);
        return key;
    }

    public static String format(String s, Map<String, String> map) {
        int end;
        int start;
        StringBuilder sb = new StringBuilder((int)((double)s.length() * 1.5));
        int cursor = 0;
        while ((start = s.indexOf("${", cursor)) != -1 && (end = s.indexOf(125, start)) != -1) {
            sb.append(s.substring(cursor, start));
            String key = s.substring(start + 2, end);
            sb.append(map.get(StringUtils.trim((String)key)));
            cursor = end + 1;
        }
        sb.append(s.substring(cursor, s.length()));
        return sb.toString();
    }

    public static String format(String s, Object ... args) {
        return MessageFormat.format(s, args);
    }

    public static String replace(String str, String regex, String ... args) {
        int length = args.length;
        for (int i = 0; i < length; ++i) {
            str = str.replaceFirst(regex, args[i]);
        }
        return str;
    }

    public static String escapeHtml(String html) {
        return StringEscapeUtils.escapeHtml4((String)html);
    }

    public static String cleanChars(String txt) {
        return txt.replaceAll("[ \u3000\t`\u00b7\u2022\ufffd\u0001\\f\\t\\v]", "");
    }

    public static String random(int count, RandomType randomType) {
        if (count == 0) {
            return "";
        }
        if (count < 0) {
            throw new IllegalArgumentException("Requested random string length " + count + " is less than 0.");
        }
        char[] buffer = new char[count];
        for (int i = 0; i < count; ++i) {
            buffer[i] = randomType.equals((Object)RandomType.INT) ? _INT.charAt(RANDOM.nextInt(_INT.length())) : (randomType.equals((Object)RandomType.STRING) ? _STR.charAt(RANDOM.nextInt(_STR.length())) : _ALL.charAt(RANDOM.nextInt(_ALL.length())));
        }
        return new String(buffer);
    }

    public static void main(String[] args) {
        System.out.println(StringUtils.random(32, RandomType.ALL));
    }

    public static enum RandomType {
        INT,
        STRING,
        ALL;

    }
}

