/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import xin.altitude.cms.common.entity.TreeNode;
import xin.altitude.cms.common.lang.ITreeEntity;
import xin.altitude.cms.common.util.EntityUtils;
import xin.altitude.cms.common.util.RefUtils;

public class TreeUtils {
    private TreeUtils() {
    }

    public static <T> List<TreeNode<T>> createNode(List<? extends ITreeEntity<T>> data, T parentId) {
        return TreeUtils.doCreateNode(data, parentId, null);
    }

    public static <T> List<TreeNode<T>> createNode(List<? extends ITreeEntity<T>> data, T parentId, Comparator<TreeNode<T>> comparator) {
        return TreeUtils.doCreateNode(data, parentId, comparator);
    }

    public static <D, T> List<TreeNode<T>> createNode(List<D> data, T parentId, Function<D, T> idAction, Function<D, String> nameAction, Function<D, T> pidAction) {
        return TreeUtils.createNode(data, parentId, idAction, nameAction, pidAction, null);
    }

    public static <D, T> List<TreeNode<T>> createNode(List<D> data, T parentId, Function<D, T> idAction, Function<D, String> nameAction, Function<D, T> pidAction, Comparator<TreeNode<T>> comparator) {
        Map<T, List<D>> map = data.stream().collect(Collectors.groupingBy(pidAction));
        return TreeUtils.doCreateNode(map, parentId, idAction, nameAction, comparator);
    }

    public static <B, T, L> List<B> createNodeDetail(List<B> data, T parentId, Function<B, T> idAction, Function<B, T> pidAction, SFunction<B, L> childAction) {
        Map<T, List<B>> map = data.stream().collect(Collectors.groupingBy(pidAction));
        return TreeUtils.doCreateNode(map, parentId, idAction, childAction);
    }

    private static <T> List<TreeNode<T>> doCreateNode(List<? extends ITreeEntity<T>> root, T parentId, Comparator<TreeNode<T>> comparator) {
        List<TreeNode<TreeNode>> lists = root.stream().filter(e -> e.getParentId().equals(parentId)).map(e -> new TreeNode(e.getId(), e.getName())).collect(Collectors.toList());
        Optional.ofNullable(comparator).ifPresent(lists::sort);
        lists.forEach(e -> e.setChildList(TreeUtils.doCreateNode(root, e.getId(), comparator)));
        return lists;
    }

    private static <T> List<TreeNode<T>> doCreateNode(Map<T, List<? extends ITreeEntity<T>>> map, T parentId, Comparator<TreeNode<T>> comparator) {
        List<TreeNode<TreeNode>> lists = EntityUtils.toList((Collection)map.get(parentId), e -> new TreeNode(e.getId(), e.getName()));
        Optional.ofNullable(comparator).ifPresent(lists::sort);
        lists.forEach(e -> e.setChildList(TreeUtils.doCreateNode(map, e.getId(), comparator)));
        return lists;
    }

    private static <W, T> List<TreeNode<T>> doCreateNode(List<W> root, T parentId, Function<W, T> idAction, Function<W, String> nameAction, Function<W, T> pidAction, Comparator<TreeNode<T>> comparator) {
        List<TreeNode<TreeNode>> lists = root.stream().filter(e -> EntityUtils.toObj(e, pidAction).equals(parentId)).map(e -> new TreeNode(EntityUtils.toObj(e, idAction), (String)EntityUtils.toObj(e, nameAction))).collect(Collectors.toList());
        Optional.ofNullable(comparator).ifPresent(lists::sort);
        lists.forEach(e -> e.setChildList(TreeUtils.doCreateNode(root, e.getId(), idAction, nameAction, pidAction, comparator)));
        return lists;
    }

    private static <W, T> List<TreeNode<T>> doCreateNode(Map<T, List<W>> map, T parentId, Function<W, T> idAction, Function<W, String> nameAction, Comparator<TreeNode<T>> comparator) {
        List<TreeNode<TreeNode>> lists = EntityUtils.toList((Collection)map.get(parentId), e -> new TreeNode(EntityUtils.toObj(e, idAction), (String)EntityUtils.toObj(e, nameAction)));
        Optional.ofNullable(comparator).ifPresent(lists::sort);
        lists.forEach(e -> e.setChildList(TreeUtils.doCreateNode(map, e.getId(), idAction, nameAction, comparator)));
        return lists;
    }

    private static <B, T, L> List<B> doCreateNode(Map<T, List<B>> map, T parentId, Function<B, T> idAction, SFunction<B, L> childAction) {
        List lists = Optional.ofNullable(map.get(parentId)).orElse(new ArrayList());
        if (lists.size() > 0) {
            lists.forEach(e -> RefUtils.setFiledValue(e, childAction, TreeUtils.doCreateNode(map, EntityUtils.toObj(e, idAction), idAction, childAction)));
        }
        return lists;
    }
}

