/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import xin.altitude.cms.common.util.StringUtil;

public class ResourceUtils {
    private static final PathMatchingResourcePatternResolver RESOLVER = new PathMatchingResourcePatternResolver();

    private ResourceUtils() {
    }

    public static Resource[] resolveMapperLocations(String mapperLocations) {
        Optional<String> optional = Optional.ofNullable(mapperLocations);
        if (optional.isPresent()) {
            return ResourceUtils.resolveMapperLocations(StringUtil.split((String)mapperLocations, (String)","));
        }
        return new Resource[0];
    }

    public static Resource[] resolveMapperLocations(String[] mapperLocations) {
        ArrayList resources = new ArrayList();
        if (mapperLocations != null) {
            Arrays.stream(mapperLocations).forEach(mapperLocation -> {
                try {
                    resources.addAll(Arrays.asList(RESOLVER.getResources(mapperLocation)));
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            });
        }
        return resources.toArray(new Resource[0]);
    }

    public static Resource resolveConfigLocation(String configLocation) {
        return RESOLVER.getResource(configLocation);
    }
}

