/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.util.Assert;
import xin.altitude.cms.common.util.SpringUtils;

public class RedisUtils {
    private static final StringRedisTemplate STRING_REDIS_TEMPLATE = SpringUtils.getBean(StringRedisTemplate.class);
    private static final ValueOperations<String, String> OPS_FOR_VALUE = STRING_REDIS_TEMPLATE.opsForValue();

    public static Boolean setBit(String key, int offset) {
        RedisUtils.validOffset(offset);
        return RedisUtils.setBit(key, offset, (Boolean)true);
    }

    public static Boolean setBit(String key, int offset, Boolean value) {
        RedisUtils.validOffset(offset);
        return OPS_FOR_VALUE.setBit((Object)key, (long)offset, value.booleanValue());
    }

    public static Boolean getBit(String key, int offset) {
        RedisUtils.validOffset(offset);
        return OPS_FOR_VALUE.getBit((Object)key, (long)offset);
    }

    public static Boolean setBit(String key, Long offset) {
        RedisUtils.validOffset(offset);
        return RedisUtils.setBit(key, offset, (Boolean)true);
    }

    public static Boolean setBit(String key, Long offset, Boolean value) {
        RedisUtils.validOffset(offset);
        return OPS_FOR_VALUE.setBit((Object)key, offset.longValue(), value.booleanValue());
    }

    public static Boolean getBit(String key, Long offset) {
        RedisUtils.validOffset(offset);
        return OPS_FOR_VALUE.getBit((Object)key, offset.longValue());
    }

    public static Long bitCount(String key) {
        return (Long)STRING_REDIS_TEMPLATE.execute(con -> con.bitCount(key.getBytes()));
    }

    public static Long bitCount(String key, int start, int end) {
        return (Long)STRING_REDIS_TEMPLATE.execute(con -> con.bitCount(key.getBytes(), (long)start, (long)end));
    }

    public static Long bitOp(RedisStringCommands.BitOperation op, String saveKey, String ... desKey) {
        byte[][] bytes = new byte[desKey.length][];
        for (int i = 0; i < desKey.length; ++i) {
            bytes[i] = desKey[i].getBytes();
        }
        return (Long)STRING_REDIS_TEMPLATE.execute(con -> con.bitOp(op, saveKey.getBytes(), bytes));
    }

    public static Long bitOpResult(RedisStringCommands.BitOperation op, String saveKey, String ... desKey) {
        RedisUtils.bitOp(op, saveKey, desKey);
        return RedisUtils.bitCount(saveKey);
    }

    private static void validOffset(long offset) {
        Assert.isTrue((offset >= 0L && offset <= 0xFFFFFFFFL ? 1 : 0) != 0, (String)"\u53c2\u6570\u3010offset\u3011\u8d8a\u754c");
    }

    public static List<Object> getMultiCacheMapValue(String key, Collection<Object> hKeys) {
        return STRING_REDIS_TEMPLATE.opsForHash().multiGet((Object)key, hKeys);
    }

    public static List<String> getCacheList(String key) {
        return STRING_REDIS_TEMPLATE.opsForList().range((Object)key, 0L, -1L);
    }

    public static Set<String> getCacheSet(String key) {
        return STRING_REDIS_TEMPLATE.opsForSet().members((Object)key);
    }

    public static void setObject(String key, Object value) {
        if (value instanceof String) {
            OPS_FOR_VALUE.set((Object)key, (Object)((String)value));
        } else {
            try {
                String json = SpringUtils.getBean(ObjectMapper.class).writeValueAsString(value);
                Optional.ofNullable(json).ifPresent(e -> OPS_FOR_VALUE.set((Object)key, e));
            }
            catch (JsonProcessingException e2) {
                e2.printStackTrace();
            }
        }
    }

    public static void setObject(String key, Object value, Integer timeout, TimeUnit timeUnit) {
        if (value instanceof String) {
            OPS_FOR_VALUE.set((Object)key, (Object)((String)value), (long)timeout.intValue(), timeUnit);
        } else {
            try {
                String json = SpringUtils.getBean(ObjectMapper.class).writeValueAsString(value);
                Optional.ofNullable(json).ifPresent(e -> OPS_FOR_VALUE.set((Object)key, e, (long)timeout.intValue(), timeUnit));
            }
            catch (JsonProcessingException e2) {
                e2.printStackTrace();
            }
        }
    }

    public static Boolean setObjectIfAbsent(String key, Object value) {
        if (value instanceof String) {
            return OPS_FOR_VALUE.setIfAbsent((Object)key, (Object)((String)value));
        }
        try {
            String json = SpringUtils.getBean(ObjectMapper.class).writeValueAsString(value);
            return Optional.ofNullable(json).map(e -> OPS_FOR_VALUE.setIfAbsent((Object)key, e)).orElse(false);
        }
        catch (JsonProcessingException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public static Boolean setObjectIfAbsent(String key, Object value, Integer timeout, TimeUnit timeUnit) {
        if (value instanceof String) {
            return OPS_FOR_VALUE.setIfAbsent((Object)key, (Object)((String)value), (long)timeout.intValue(), timeUnit);
        }
        try {
            String json = SpringUtils.getBean(ObjectMapper.class).writeValueAsString(value);
            return Optional.ofNullable(json).map(e -> OPS_FOR_VALUE.setIfAbsent((Object)key, e, (long)timeout.intValue(), timeUnit)).orElse(false);
        }
        catch (JsonProcessingException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public static Boolean expire(String key, Long timeout) {
        return RedisUtils.expire(key, timeout, TimeUnit.SECONDS);
    }

    public static Boolean expire(String key, Long timeout, TimeUnit unit) {
        return STRING_REDIS_TEMPLATE.expire((Object)key, timeout.longValue(), unit);
    }

    public static <T> T getObject(String key, Class<T> clazz) {
        String fromValue = (String)OPS_FOR_VALUE.get((Object)key);
        if (fromValue != null) {
            try {
                return (T)SpringUtils.getBean(ObjectMapper.class).readValue(fromValue, clazz);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Boolean deleteObject(String key) {
        return STRING_REDIS_TEMPLATE.delete((Object)key);
    }

    public static Long deleteObject(Collection<String> keys) {
        return STRING_REDIS_TEMPLATE.delete(keys);
    }

    public static Long setCacheList(String key, List<String> dataList) {
        Long count = STRING_REDIS_TEMPLATE.opsForList().rightPushAll((Object)key, dataList);
        return count == null ? 0L : count;
    }

    public static BoundSetOperations<String, String> setCacheSet(String key, Set<String> dataSet) {
        BoundSetOperations setOperation = STRING_REDIS_TEMPLATE.boundSetOps((Object)key);
        for (String s : dataSet) {
            setOperation.add((Object[])new String[]{s});
        }
        return setOperation;
    }

    public static void setCacheMap(String key, Map<String, String> dataMap) {
        if (dataMap != null) {
            STRING_REDIS_TEMPLATE.opsForHash().putAll((Object)key, dataMap);
        }
    }

    public static Map<Object, Object> getCacheMap(String key) {
        return STRING_REDIS_TEMPLATE.opsForHash().entries((Object)key);
    }

    public static void setCacheMapValue(String key, String hKey, String value) {
        STRING_REDIS_TEMPLATE.opsForHash().put((Object)key, (Object)hKey, (Object)value);
    }

    public static String getCacheMapValue(String key, String hKey) {
        HashOperations opsForHash = STRING_REDIS_TEMPLATE.opsForHash();
        return (String)opsForHash.get((Object)key, (Object)hKey);
    }

    public static void delCacheMapValue(String key, String hkey) {
        HashOperations hashOperations = STRING_REDIS_TEMPLATE.opsForHash();
        hashOperations.delete((Object)key, new Object[]{hkey});
    }

    public static Collection<String> keys(String pattern) {
        return STRING_REDIS_TEMPLATE.keys((Object)pattern);
    }

    public static void publishMsg(String channelName, Object msg) {
        if (msg instanceof String) {
            STRING_REDIS_TEMPLATE.convertAndSend(channelName, msg);
        } else {
            try {
                String json = SpringUtils.getBean(ObjectMapper.class).writeValueAsString(msg);
                Optional.ofNullable(json).ifPresent(e -> STRING_REDIS_TEMPLATE.convertAndSend(channelName, e));
            }
            catch (JsonProcessingException e2) {
                e2.printStackTrace();
            }
        }
    }
}

