/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import xin.altitude.cms.common.model.KVModel;
import xin.altitude.cms.common.util.EntityUtils;

public class MapUtils {
    private MapUtils() {
    }

    @SafeVarargs
    public static <K, V> List<V> getCollection(Map<K, V> source, K ... keys) {
        Objects.requireNonNull(keys);
        return MapUtils.getCollection(source, Arrays.asList(keys));
    }

    public static <K, V> List<V> getCollection(Map<K, V> source, Iterable<K> keys) {
        ArrayList result = new ArrayList();
        if (source != null && !source.isEmpty() && keys != null) {
            keys.forEach(key -> Optional.ofNullable(source.get(key)).ifPresent(result::add));
        }
        return result;
    }

    public static <K, V> List<V> getCollection(Map<K, V> source, Iterable<K> keys, Comparator<V> comparator) {
        Objects.requireNonNull(comparator);
        List<V> result = MapUtils.getCollection(source, keys);
        result.sort(comparator);
        return result;
    }

    public static <K, V> List<KVModel<K, V>> mapToList(Map<K, V> source) {
        Objects.requireNonNull(source);
        List<KVModel<K, V>> result = source.entrySet().stream().map(e -> new KVModel(e.getKey(), e.getValue())).collect(Collectors.toList());
        return result;
    }

    public static <K, V, T> Map<K, T> transMap(Map<K, V> map, Function<? super V, ? extends T> valueAction) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(valueAction);
        HashMap<K, T> hashMap = new HashMap<K, T>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), EntityUtils.toObj(entry.getValue(), valueAction));
        }
        return hashMap;
    }
}

