/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.redisson.api.RLock;

public final class LockOptional<T extends RLock> {
    private static final LockOptional<?> EMPTY = new LockOptional();
    private final T value;

    private LockOptional() {
        this.value = null;
    }

    private LockOptional(T value) {
        this.value = (RLock)Objects.requireNonNull(value);
    }

    public static <T extends RLock> LockOptional<T> empty() {
        LockOptional<?> t = EMPTY;
        return t;
    }

    public static <T extends RLock> LockOptional<T> of(T value) {
        return new LockOptional<T>(value);
    }

    public static <T extends RLock> LockOptional<T> ofNullable(T value) {
        return value == null ? LockOptional.empty() : LockOptional.of(value);
    }

    public T get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public void ifLocked(Consumer<? super T> consumer) {
        if (this.value != null && this.value.isLocked()) {
            consumer.accept(this.value);
        }
    }

    public T orElse(T other) {
        return this.value != null ? this.value : other;
    }

    public T orElseGet(Supplier<? extends T> other) {
        return (T)(this.value != null ? this.value : (RLock)other.get());
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.value != null) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LockOptional)) {
            return false;
        }
        LockOptional other = (LockOptional)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.value != null ? String.format("LockOptional[%s]", this.value) : "LockOptional.empty";
    }
}

