/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import xin.altitude.cms.common.util.SpringUtils;

public class JacksonUtils {
    private static final ObjectMapper OBJECT_MAPPER = SpringUtils.getBean(ObjectMapper.class);

    public static String toJSONString(Object object) {
        try {
            return JacksonUtils.writeValueAsString(object);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T parse(String json, Class<T> tClass) {
        try {
            return JacksonUtils.parseThrows(json, tClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T parse(String json, TypeReference<T> valueTypeRef) {
        try {
            return JacksonUtils.parseThrows(json, valueTypeRef);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String writeValueAsString(Object object) {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T parseThrows(String json, Class<T> tClass) throws Exception {
        return (T)OBJECT_MAPPER.readValue(json, tClass);
    }

    public static <T> T parseThrows(String json, TypeReference<T> valueTypeRef) throws JsonProcessingException {
        return (T)OBJECT_MAPPER.readValue(json, valueTypeRef);
    }

    @Nullable
    public static String toJson(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] toJsonAsBytes(@Nullable Object object) {
        if (object == null) {
            return new byte[0];
        }
        try {
            return OBJECT_MAPPER.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JsonNode readTree(String jsonString) {
        Objects.requireNonNull(jsonString, "jsonString is null");
        try {
            return OBJECT_MAPPER.readTree(jsonString);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JsonNode readTree(InputStream in) {
        Objects.requireNonNull(in, "InputStream in is null");
        try {
            return OBJECT_MAPPER.readTree(in);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JsonNode readTree(byte[] content) {
        Objects.requireNonNull(content, "byte[] content is null");
        try {
            return OBJECT_MAPPER.readTree(content);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JsonNode readTree(JsonParser jsonParser) {
        Objects.requireNonNull(jsonParser, "jsonParser is null");
        try {
            return (JsonNode)OBJECT_MAPPER.readTree(jsonParser);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable byte[] content, Class<T> valueType) {
        if (ObjectUtils.isEmpty((Object)content)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(content, valueType);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable String jsonString, Class<T> valueType) {
        if (!StringUtils.hasLength((String)jsonString)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(jsonString, valueType);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable InputStream in, Class<T> valueType) {
        if (in == null) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(in, valueType);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable byte[] content, TypeReference<T> typeReference) {
        if (ObjectUtils.isEmpty((Object)content)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(content, typeReference);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable String jsonString, TypeReference<T> typeReference) {
        if (!StringUtils.hasLength((String)jsonString)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(jsonString, typeReference);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable InputStream in, TypeReference<T> typeReference) {
        if (in == null) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(in, typeReference);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable byte[] content, JavaType javaType) {
        if (ObjectUtils.isEmpty((Object)content)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(content, javaType);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable String jsonString, JavaType javaType) {
        if (!StringUtils.hasLength((String)jsonString)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(jsonString, javaType);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable InputStream in, JavaType javaType) {
        if (in == null) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(in, javaType);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MapType getMapType(Class<?> valueClass) {
        return JacksonUtils.getMapType(String.class, valueClass);
    }

    public static MapType getMapType(Class<?> keyClass, Class<?> valueClass) {
        return OBJECT_MAPPER.getTypeFactory().constructMapType(Map.class, keyClass, valueClass);
    }

    public static CollectionLikeType getListType(Class<?> elementClass) {
        return OBJECT_MAPPER.getTypeFactory().constructCollectionLikeType(List.class, elementClass);
    }

    public static JavaType getParametricType(Class<?> parametrized, Class<?> ... parameterClasses) {
        return OBJECT_MAPPER.getTypeFactory().constructParametricType(parametrized, (Class[])parameterClasses);
    }

    public static <T> List<T> readList(@Nullable byte[] content, Class<T> elementClass) {
        if (ObjectUtils.isEmpty((Object)content)) {
            return Collections.emptyList();
        }
        try {
            return (List)OBJECT_MAPPER.readValue(content, (JavaType)JacksonUtils.getListType(elementClass));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> List<T> readList(@Nullable InputStream content, Class<T> elementClass) {
        if (content == null) {
            return Collections.emptyList();
        }
        try {
            return (List)OBJECT_MAPPER.readValue(content, (JavaType)JacksonUtils.getListType(elementClass));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> List<T> readList(@Nullable String content, Class<T> elementClass) {
        if (!StringUtils.hasLength((String)content)) {
            return Collections.emptyList();
        }
        try {
            return (List)OBJECT_MAPPER.readValue(content, (JavaType)JacksonUtils.getListType(elementClass));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> readMap(@Nullable byte[] content) {
        return JacksonUtils.readMap(content, Object.class);
    }

    public static Map<String, Object> readMap(@Nullable InputStream content) {
        return JacksonUtils.readMap(content, Object.class);
    }

    public static Map<String, Object> readMap(@Nullable String content) {
        return JacksonUtils.readMap(content, Object.class);
    }

    public static <V> Map<String, V> readMap(@Nullable byte[] content, Class<?> valueClass) {
        return JacksonUtils.readMap(content, String.class, valueClass);
    }

    public static <V> Map<String, V> readMap(@Nullable InputStream content, Class<?> valueClass) {
        return JacksonUtils.readMap(content, String.class, valueClass);
    }

    public static <V> Map<String, V> readMap(@Nullable String content, Class<?> valueClass) {
        return JacksonUtils.readMap(content, String.class, valueClass);
    }

    public static <K, V> Map<K, V> readMap(@Nullable byte[] content, Class<?> keyClass, Class<?> valueClass) {
        if (ObjectUtils.isEmpty((Object)content)) {
            return Collections.emptyMap();
        }
        try {
            return (Map)OBJECT_MAPPER.readValue(content, (JavaType)JacksonUtils.getMapType(keyClass, valueClass));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <K, V> Map<K, V> readMap(@Nullable InputStream content, Class<?> keyClass, Class<?> valueClass) {
        if (content == null) {
            return Collections.emptyMap();
        }
        try {
            return (Map)OBJECT_MAPPER.readValue(content, (JavaType)JacksonUtils.getMapType(keyClass, valueClass));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <K, V> Map<K, V> readMap(@Nullable String content, Class<?> keyClass, Class<?> valueClass) {
        if (!StringUtils.hasLength((String)content)) {
            return Collections.emptyMap();
        }
        try {
            return (Map)OBJECT_MAPPER.readValue(content, (JavaType)JacksonUtils.getMapType(keyClass, valueClass));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)OBJECT_MAPPER.convertValue(fromValue, toValueType);
    }

    public static <T> T convertValue(Object fromValue, JavaType toValueType) {
        return (T)OBJECT_MAPPER.convertValue(fromValue, toValueType);
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) {
        return (T)OBJECT_MAPPER.convertValue(fromValue, toValueTypeRef);
    }

    public static <T> T treeToValue(TreeNode treeNode, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.treeToValue(treeNode, valueType);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T extends JsonNode> T valueToTree(@Nullable Object fromValue) {
        return (T)OBJECT_MAPPER.valueToTree(fromValue);
    }

    public static ObjectNode createObjectNode() {
        return OBJECT_MAPPER.createObjectNode();
    }

    public static ArrayNode createArrayNode() {
        return OBJECT_MAPPER.createArrayNode();
    }

    public static <T> T clone(T obj, Class<T> clazz) {
        return JacksonUtils.readValue(JacksonUtils.writeValueAsString(obj), clazz);
    }
}

