/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.LambdaMeta;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ibatis.reflection.property.PropertyNamer;
import xin.altitude.cms.common.support.FieldFilterSupport;
import xin.altitude.cms.common.util.EntityUtils;
import xin.altitude.cms.common.util.LambdaUtils;
import xin.altitude.cms.common.util.RefUtils;

public class FieldFilterUtils {
    private FieldFilterUtils() {
    }

    @SafeVarargs
    public static <T, R> void removeFields(List<T> sources, SFunction<? super T, ? extends R> ... action) {
        if (action == null) {
            return;
        }
        sources.forEach(e -> FieldFilterUtils.removeFields(e, action));
    }

    public static <T, R> void filterFields(List<T> sources, boolean isInclude, String ... fieldNames) {
        sources.forEach(e -> FieldFilterUtils.filterFields(e, isInclude, fieldNames));
    }

    @SafeVarargs
    public static <T, R> void removeFields(IPage<T> sources, SFunction<? super T, ? extends R> ... action) {
        if (action == null) {
            return;
        }
        sources.getRecords().forEach(e -> FieldFilterUtils.removeFields(e, action));
    }

    @SafeVarargs
    public static <T, R> void removeFields(T source, SFunction<? super T, ? extends R> ... action) {
        if (action == null) {
            return;
        }
        Class<?> currentClass = source.getClass();
        Class<?> superclass = currentClass.getSuperclass();
        List fieldNames = Arrays.stream(action).map(LambdaUtils::extract).map(LambdaMeta::getImplMethodName).map(PropertyNamer::methodToProperty).collect(Collectors.toList());
        for (Field field : currentClass.getDeclaredFields()) {
            for (String fieldName : fieldNames) {
                FieldFilterUtils.doRemoveField(source, fieldName, field);
            }
        }
        for (Field field : superclass.getDeclaredFields()) {
            for (String fieldName : fieldNames) {
                FieldFilterUtils.doRemoveField(source, fieldName, field);
            }
        }
    }

    public static <T, R> void filterFields(T source, boolean isInclude, String ... fieldNames) {
        Class<?> currentClass = source.getClass();
        Class<?> superclass = currentClass.getSuperclass();
        Set set = Arrays.stream(fieldNames).collect(Collectors.toSet());
        if (isInclude) {
            Arrays.stream(currentClass.getDeclaredFields()).filter(e -> !set.contains(e.getName())).forEach(e -> FieldFilterUtils.doRemoveField(source, e));
            Arrays.stream(superclass.getDeclaredFields()).filter(e -> !set.contains(e.getName())).forEach(e -> FieldFilterUtils.doRemoveField(source, e));
        } else {
            Arrays.stream(currentClass.getDeclaredFields()).filter(e -> set.contains(e.getName())).forEach(e -> FieldFilterUtils.doRemoveField(source, e));
            Arrays.stream(superclass.getDeclaredFields()).filter(e -> set.contains(e.getName())).forEach(e -> FieldFilterUtils.doRemoveField(source, e));
        }
    }

    @SafeVarargs
    public static <T, R> List<JSONObject> filterFields(List<T> data, SFunction<T, R> ... action) {
        return FieldFilterUtils.filterFields(data, false, action);
    }

    @SafeVarargs
    public static <T, R> List<JSONObject> filterFields(List<T> data, boolean isInclude, SFunction<T, R> ... action) {
        if (data == null) {
            return null;
        }
        return data.stream().map(e -> FieldFilterUtils.filterFields(e, isInclude, action)).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <T, R> IPage<JSONObject> filterFields(IPage<T> page, SFunction<T, R> ... action) {
        return FieldFilterUtils.filterFields(page, false, action);
    }

    @SafeVarargs
    public static <T, R> IPage<JSONObject> filterFields(IPage<T> page, boolean isInclude, SFunction<T, R> ... action) {
        if (page == null) {
            return null;
        }
        return EntityUtils.toPage(page, e -> FieldFilterUtils.filterFields(e, isInclude, action));
    }

    @SafeVarargs
    public static <T, R> JSONObject filterFields(T obj, SFunction<T, R> ... action) {
        return FieldFilterUtils.filterFields(obj, false, action);
    }

    @SafeVarargs
    public static <T, R> JSONObject filterFields(T obj, boolean isInclude, SFunction<T, R> ... action) {
        if (obj == null) {
            return null;
        }
        String fieldNames = RefUtils.getFiledNames(action).stream().collect(Collectors.joining(","));
        return isInclude ? FieldFilterSupport.filter(obj, fieldNames, null) : FieldFilterSupport.filter(obj, null, fieldNames);
    }

    private static <T> void doRemoveField(T source, String fieldName, Field field) {
        if (field.getName().equals(fieldName)) {
            try {
                field.setAccessible(true);
                field.set(source, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static <T> void doRemoveField(T source, Field field) {
        try {
            field.setAccessible(true);
            field.set(source, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

