/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import com.baomidou.mybatisplus.core.metadata.IPage;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import xin.altitude.cms.common.util.ColUtils;
import xin.altitude.cms.common.util.RefUtils;

public class EntityUtils {
    private EntityUtils() {
    }

    public static <R, S, T, A> R collectCommon(Collection<S> source, Function<? super S, ? extends T> action, Collector<? super T, A, R> collector) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(collector);
        return source.stream().map(action).collect(collector);
    }

    @SafeVarargs
    public static <S, T> Set<T> collectSet(Function<? super S, ? extends T> action, S ... source) {
        Objects.requireNonNull(source);
        return EntityUtils.collectSet(Arrays.asList(source), action);
    }

    public static <S, T> Set<T> collectSet(Collection<S> source, Function<? super S, ? extends T> action) {
        Objects.requireNonNull(source);
        return source.stream().map(action).collect(Collectors.toSet());
    }

    public static <S> List<? extends S> collectList(Collection<S> source, Function<? super S, ? extends S> action) {
        return EntityUtils.collectCommon(source, action, Collectors.toList());
    }

    public static <T, R> R toObj(T obj, Function<? super T, ? extends R> action) {
        Objects.requireNonNull(action);
        return Optional.ofNullable(obj).map(action).orElse(null);
    }

    public static <T, R> List<R> toList(Collection<T> data, Function<? super T, ? extends R> action) {
        Objects.requireNonNull(action);
        if (Objects.nonNull(data)) {
            return data.stream().map(action).collect(Collectors.toList());
        }
        return new ArrayList();
    }

    public static <T, VO> List<VO> toList(Collection<T> data, Class<VO> voClazz) {
        T obj;
        Constructor constructor;
        if (data != null && data.size() > 0 && Objects.nonNull(constructor = RefUtils.getConstructor(voClazz, (obj = ColUtils.toObj(data)).getClass()))) {
            return EntityUtils.toList(data, (? super T e) -> RefUtils.newInstance(constructor, e));
        }
        return new ArrayList();
    }

    public static <T, R> R[] toArray(T[] source, Function<? super T, ? extends R> action) {
        Objects.requireNonNull(action);
        if (Objects.nonNull(source)) {
            return Arrays.stream(source).map(action).toArray();
        }
        return new ArrayList().toArray();
    }

    public static <E extends IPage<T>, T, R> IPage<R> toPage(E page, Function<? super T, ? extends R> action) {
        Objects.requireNonNull(page);
        Objects.requireNonNull(action);
        return page.convert(action);
    }

    public static <T, K> Map<K, T> toMap(Collection<T> data, Function<? super T, ? extends K> keyAction) {
        Objects.requireNonNull(data);
        Objects.requireNonNull(keyAction);
        return data.stream().collect(Collectors.toMap(keyAction, Function.identity()));
    }

    public static <T, K, V> Map<K, V> toMap(Collection<T> data, Function<? super T, ? extends K> keyAction, Function<? super T, ? extends V> valueAction) {
        Objects.requireNonNull(data);
        Objects.requireNonNull(keyAction);
        Objects.requireNonNull(valueAction);
        return data.stream().collect(Collectors.toMap(keyAction, valueAction));
    }

    public static <T, R> Set<R> toSet(Collection<T> data, Function<? super T, ? extends R> action) {
        Objects.requireNonNull(action);
        if (Objects.nonNull(data)) {
            return data.stream().map(action).collect(Collectors.toSet());
        }
        return new HashSet();
    }

    public static <E, R> Map<R, List<E>> groupBy(Collection<E> data, Function<E, R> gColumn) {
        Objects.requireNonNull(gColumn);
        if (Objects.nonNull(data)) {
            return data.stream().collect(Collectors.groupingBy(gColumn));
        }
        return new HashMap();
    }

    public static <E, G, U> Map<G, List<U>> groupBy(Collection<E> data, Function<E, G> gColumn, Function<E, U> action) {
        Objects.requireNonNull(gColumn);
        if (Objects.nonNull(data)) {
            return data.stream().collect(Collectors.groupingBy(gColumn, Collectors.mapping(action, Collectors.toList())));
        }
        return new HashMap(16);
    }
}

