/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ColUtils {
    private ColUtils() {
    }

    public static <E> List<E> toCol(E e) {
        return ColUtils.toCol(e, ArrayList::new);
    }

    public static <E, C extends List<E>> List<E> toCol(E t, Supplier<C> supplier) {
        if (t == null) {
            return new ArrayList();
        }
        return (List)Stream.of(t).collect(Collectors.toCollection(supplier));
    }

    public static <E> E toObj(Collection<E> collection) {
        Collection coll = Optional.ofNullable(collection).orElseGet(ArrayList::new);
        return coll.stream().findFirst().orElse(null);
    }

    public static <E> E max(Collection<E> data, ToIntFunction<? super E> column) {
        if (data == null) {
            return null;
        }
        return data.stream().max(Comparator.comparingInt(column)).orElse(null);
    }

    public static <E, U extends Comparable<? super U>> E max(Collection<E> data, Function<? super E, ? extends U> column) {
        if (data == null) {
            return null;
        }
        return data.stream().max(Comparator.comparing(column)).orElse(null);
    }

    public static <E> E max(Collection<E> data, Comparator<? super E> comparator) {
        if (data == null) {
            return null;
        }
        return data.stream().max(comparator).orElse(null);
    }

    public static <E> E min(Collection<E> data, ToIntFunction<? super E> column) {
        if (data == null) {
            return null;
        }
        return data.stream().min(Comparator.comparingInt(column)).orElse(null);
    }

    public static <E, U extends Comparable<? super U>> E min(Collection<E> data, Function<? super E, ? extends U> column) {
        if (data == null) {
            return null;
        }
        return data.stream().min(Comparator.comparing(column)).orElse(null);
    }

    public static <E> E min(Collection<E> data, Comparator<? super E> comparator) {
        if (data == null) {
            return null;
        }
        return data.stream().min(comparator).orElse(null);
    }
}

