/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.support;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import xin.altitude.cms.common.support.DynamicExclude;
import xin.altitude.cms.common.support.DynamicInclude;

public class FieldFilterSupport {
    public static final String DYNC_INCLUDE = "DYNC_INCLUDE";
    public static final String DYNC_EXCLUDE = "DYNC_EXCLUDE";
    private static final ObjectMapper INCLUDE_MAPPER = new ObjectMapper();
    private static final ObjectMapper EXCLUDE_MAPPER = new ObjectMapper();

    public static JSONObject filter(Object object, String include, String exclude) {
        if (include != null && include.length() > 0) {
            INCLUDE_MAPPER.setFilterProvider((FilterProvider)new SimpleFilterProvider().addFilter(DYNC_INCLUDE, SimpleBeanPropertyFilter.filterOutAllExcept((String[])include.split(","))));
            INCLUDE_MAPPER.addMixIn(object.getClass(), DynamicInclude.class);
            return FieldFilterSupport.doFilter(object, INCLUDE_MAPPER);
        }
        if (exclude != null && exclude.length() > 0) {
            EXCLUDE_MAPPER.setFilterProvider((FilterProvider)new SimpleFilterProvider().addFilter(DYNC_EXCLUDE, SimpleBeanPropertyFilter.serializeAllExcept((String[])exclude.split(","))));
            EXCLUDE_MAPPER.addMixIn(object.getClass(), DynamicExclude.class);
            return FieldFilterSupport.doFilter(object, EXCLUDE_MAPPER);
        }
        return null;
    }

    private static JSONObject doFilter(Object object, ObjectMapper mapper) {
        try {
            String valueAsString = mapper.writeValueAsString(object);
            return (JSONObject)JSON.parseObject((String)valueAsString, JSONObject.class);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        INCLUDE_MAPPER.registerModule((Module)new JavaTimeModule());
        EXCLUDE_MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

