/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.entity;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.springframework.http.HttpStatus;
import xin.altitude.cms.common.util.FieldFilterUtils;

public class AjaxResult
extends LinkedHashMap<String, Object> {
    public static final String CODE_TAG = "code";
    public static final String MSG_TAG = "msg";
    public static final String DATA_TAG = "data";
    private static final long serialVersionUID = 1L;
    private static final String SUCCESS_MSG = "\u64cd\u4f5c\u6210\u529f";

    public AjaxResult() {
    }

    public AjaxResult(int code, String msg) {
        super.put(CODE_TAG, code);
        super.put(MSG_TAG, msg);
    }

    public AjaxResult(int code, String msg, Object data) {
        super.put(CODE_TAG, code);
        super.put(MSG_TAG, msg);
        if (Objects.nonNull(data)) {
            super.put(DATA_TAG, data);
        }
    }

    public static AjaxResult success() {
        return AjaxResult.success(SUCCESS_MSG);
    }

    public static AjaxResult success(Object data) {
        return AjaxResult.success(SUCCESS_MSG, SUCCESS_MSG.equals(data) ? null : data);
    }

    public static AjaxResult success(String msg, Object data) {
        return new AjaxResult(HttpStatus.OK.value(), msg, data);
    }

    @SafeVarargs
    public static <T, R> AjaxResult success(T data, SFunction<T, R> ... action) {
        return AjaxResult.success(data, false, action);
    }

    @SafeVarargs
    public static <T, R> AjaxResult success(T data, boolean isInclude, SFunction<T, R> ... action) {
        return AjaxResult.success(SUCCESS_MSG, FieldFilterUtils.filterFields(data, isInclude, action));
    }

    @SafeVarargs
    public static <T, R> AjaxResult success(List<T> data, SFunction<T, R> ... action) {
        return AjaxResult.success(data, false, action);
    }

    @SafeVarargs
    public static <T, R> AjaxResult success(List<T> data, boolean isInclude, SFunction<T, R> ... action) {
        return AjaxResult.success(SUCCESS_MSG, FieldFilterUtils.filterFields(data, isInclude, action));
    }

    @SafeVarargs
    public static <T, R> AjaxResult success(IPage<T> data, SFunction<T, R> ... action) {
        return AjaxResult.success(data, false, action);
    }

    @SafeVarargs
    public static <T, R> AjaxResult success(IPage<T> data, boolean isInclude, SFunction<T, R> ... action) {
        return AjaxResult.success(SUCCESS_MSG, FieldFilterUtils.filterFields(data, isInclude, action));
    }

    public static AjaxResult error() {
        return AjaxResult.error("\u64cd\u4f5c\u5931\u8d25");
    }

    public static AjaxResult error(String msg) {
        return AjaxResult.error(msg, null);
    }

    public static AjaxResult error(String msg, Object data) {
        return new AjaxResult(HttpStatus.INTERNAL_SERVER_ERROR.value(), msg, data);
    }

    public static AjaxResult error(int code, String msg) {
        return new AjaxResult(code, msg, null);
    }
}

