/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.accept.RequestedContentTypeResolverBuilder;
import org.springframework.web.reactive.result.condition.ConsumesRequestCondition;
import org.springframework.web.reactive.result.condition.RequestCondition;
import org.springframework.web.reactive.result.method.RequestMappingInfo;
import org.springframework.web.reactive.result.method.RequestMappingInfoHandlerMapping;

public class RequestMappingHandlerMapping
extends RequestMappingInfoHandlerMapping
implements EmbeddedValueResolverAware {
    private final Map<String, Predicate<Class<?>>> pathPrefixes = new LinkedHashMap();
    private RequestedContentTypeResolver contentTypeResolver = new RequestedContentTypeResolverBuilder().build();
    @Nullable
    private StringValueResolver embeddedValueResolver;
    private RequestMappingInfo.BuilderConfiguration config = new RequestMappingInfo.BuilderConfiguration();

    public void setPathPrefixes(Map<String, Predicate<Class<?>>> prefixes) {
        this.pathPrefixes.clear();
        prefixes.entrySet().stream().filter(entry -> StringUtils.hasText((String)((String)entry.getKey()))).forEach(entry -> this.pathPrefixes.put((String)entry.getKey(), (Predicate<Class<?>>)entry.getValue()));
    }

    public Map<String, Predicate<Class<?>>> getPathPrefixes() {
        return Collections.unmodifiableMap(this.pathPrefixes);
    }

    public void setContentTypeResolver(RequestedContentTypeResolver contentTypeResolver) {
        Assert.notNull((Object)contentTypeResolver, (String)"'contentTypeResolver' must not be null");
        this.contentTypeResolver = contentTypeResolver;
    }

    public RequestedContentTypeResolver getContentTypeResolver() {
        return this.contentTypeResolver;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    @Override
    public void afterPropertiesSet() {
        this.config = new RequestMappingInfo.BuilderConfiguration();
        this.config.setPatternParser(this.getPathPatternParser());
        this.config.setContentTypeResolver(this.getContentTypeResolver());
        super.afterPropertiesSet();
    }

    @Override
    protected boolean isHandler(Class<?> beanType) {
        return AnnotatedElementUtils.hasAnnotation(beanType, Controller.class) || AnnotatedElementUtils.hasAnnotation(beanType, RequestMapping.class);
    }

    @Override
    @Nullable
    protected RequestMappingInfo getMappingForMethod(Method method2, Class<?> handlerType) {
        RequestMappingInfo info = this.createRequestMappingInfo(method2);
        if (info != null) {
            RequestMappingInfo typeInfo = this.createRequestMappingInfo(handlerType);
            if (typeInfo != null) {
                info = typeInfo.combine(info);
            }
            for (Map.Entry<String, Predicate<Class<?>>> entry : this.pathPrefixes.entrySet()) {
                if (!entry.getValue().test(handlerType)) continue;
                String prefix = entry.getKey();
                if (this.embeddedValueResolver != null) {
                    prefix = this.embeddedValueResolver.resolveStringValue(prefix);
                }
                info = RequestMappingInfo.paths(prefix).options(this.config).build().combine(info);
                break;
            }
        }
        return info;
    }

    @Nullable
    private RequestMappingInfo createRequestMappingInfo(AnnotatedElement element) {
        RequestMapping requestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, RequestMapping.class);
        RequestCondition<?> condition = element instanceof Class ? this.getCustomTypeCondition((Class)element) : this.getCustomMethodCondition((Method)element);
        return requestMapping != null ? this.createRequestMappingInfo(requestMapping, condition) : null;
    }

    @Nullable
    protected RequestCondition<?> getCustomTypeCondition(Class<?> handlerType) {
        return null;
    }

    @Nullable
    protected RequestCondition<?> getCustomMethodCondition(Method method2) {
        return null;
    }

    protected RequestMappingInfo createRequestMappingInfo(RequestMapping requestMapping, @Nullable RequestCondition<?> customCondition) {
        RequestMappingInfo.Builder builder = RequestMappingInfo.paths(this.resolveEmbeddedValuesInPatterns(requestMapping.path())).methods(requestMapping.method()).params(requestMapping.params()).headers(requestMapping.headers()).consumes(requestMapping.consumes()).produces(requestMapping.produces()).mappingName(requestMapping.name());
        if (customCondition != null) {
            builder.customCondition(customCondition);
        }
        return builder.options(this.config).build();
    }

    protected String[] resolveEmbeddedValuesInPatterns(String[] patterns) {
        if (this.embeddedValueResolver == null) {
            return patterns;
        }
        String[] resolvedPatterns = new String[patterns.length];
        for (int i2 = 0; i2 < patterns.length; ++i2) {
            resolvedPatterns[i2] = this.embeddedValueResolver.resolveStringValue(patterns[i2]);
        }
        return resolvedPatterns;
    }

    @Override
    public void registerMapping(RequestMappingInfo mapping, Object handler, Method method2) {
        super.registerMapping(mapping, handler, method2);
        this.updateConsumesCondition(mapping, method2);
    }

    @Override
    protected void registerHandlerMethod(Object handler, Method method2, RequestMappingInfo mapping) {
        super.registerHandlerMethod(handler, method2, mapping);
        this.updateConsumesCondition(mapping, method2);
    }

    private void updateConsumesCondition(RequestMappingInfo info, Method method2) {
        ConsumesRequestCondition condition = info.getConsumesCondition();
        if (!condition.isEmpty()) {
            for (Parameter parameter : method2.getParameters()) {
                MergedAnnotation annot = MergedAnnotations.from((AnnotatedElement)parameter).get(RequestBody.class);
                if (!annot.isPresent()) continue;
                condition.setBodyRequired(annot.getBoolean("required"));
                break;
            }
        }
    }

    @Override
    protected CorsConfiguration initCorsConfiguration(Object handler, Method method2, RequestMappingInfo mappingInfo) {
        HandlerMethod handlerMethod = this.createHandlerMethod(handler, method2);
        Class beanType = handlerMethod.getBeanType();
        CrossOrigin typeAnnotation = (CrossOrigin)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)beanType, CrossOrigin.class);
        CrossOrigin methodAnnotation = (CrossOrigin)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method2, CrossOrigin.class);
        if (typeAnnotation == null && methodAnnotation == null) {
            return null;
        }
        CorsConfiguration config = new CorsConfiguration();
        this.updateCorsConfig(config, typeAnnotation);
        this.updateCorsConfig(config, methodAnnotation);
        if (CollectionUtils.isEmpty((Collection)config.getAllowedMethods())) {
            for (RequestMethod allowedMethod : mappingInfo.getMethodsCondition().getMethods()) {
                config.addAllowedMethod(allowedMethod.name());
            }
        }
        return config.applyPermitDefaultValues();
    }

    private void updateCorsConfig(CorsConfiguration config, @Nullable CrossOrigin annotation) {
        if (annotation == null) {
            return;
        }
        for (String string : annotation.origins()) {
            config.addAllowedOrigin(this.resolveCorsAnnotationValue(string));
        }
        for (String string : annotation.methods()) {
            config.addAllowedMethod(string.name());
        }
        for (String string : annotation.allowedHeaders()) {
            config.addAllowedHeader(this.resolveCorsAnnotationValue(string));
        }
        for (String string : annotation.exposedHeaders()) {
            config.addExposedHeader(this.resolveCorsAnnotationValue(string));
        }
        String allowCredentials = this.resolveCorsAnnotationValue(annotation.allowCredentials());
        if ("true".equalsIgnoreCase(allowCredentials)) {
            config.setAllowCredentials(Boolean.valueOf(true));
        } else if ("false".equalsIgnoreCase(allowCredentials)) {
            config.setAllowCredentials(Boolean.valueOf(false));
        } else if (!allowCredentials.isEmpty()) {
            throw new IllegalStateException("@CrossOrigin's allowCredentials value must be \"true\", \"false\", or an empty string (\"\"): current value is [" + allowCredentials + "]");
        }
        if (annotation.maxAge() >= 0L && config.getMaxAge() == null) {
            config.setMaxAge(Long.valueOf(annotation.maxAge()));
        }
    }

    private String resolveCorsAnnotationValue(String value) {
        if (this.embeddedValueResolver != null) {
            String resolved = this.embeddedValueResolver.resolveStringValue(value);
            return resolved != null ? resolved : "";
        }
        return value;
    }
}

