/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.core.providers;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.SpringWebProvider;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;
import org.springframework.web.servlet.mvc.condition.PathPatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class SpringWebMvcProvider
extends SpringWebProvider {
    public String findPathPrefix(SpringDocConfigProperties springDocConfigProperties) {
        Map map = this.getHandlerMethods();
        for (Map.Entry entry : map.entrySet()) {
            RequestMappingInfo requestMappingInfo = (RequestMappingInfo)entry.getKey();
            Set<String> patterns = this.getActivePatterns(requestMappingInfo);
            if (CollectionUtils.isEmpty(patterns)) continue;
            for (String operationPath : patterns) {
                if (!operationPath.endsWith(springDocConfigProperties.getApiDocs().getPath())) continue;
                return operationPath.replace(springDocConfigProperties.getApiDocs().getPath(), "");
            }
        }
        return "";
    }

    public Set<String> getActivePatterns(Object requestMapping) {
        Set patterns = null;
        RequestMappingInfo requestMappingInfo = (RequestMappingInfo)requestMapping;
        PatternsRequestCondition patternsRequestCondition = requestMappingInfo.getPatternsCondition();
        if (patternsRequestCondition != null) {
            patterns = patternsRequestCondition.getPatterns();
        } else {
            PathPatternsRequestCondition pathPatternsRequestCondition = requestMappingInfo.getPathPatternsCondition();
            if (pathPatternsRequestCondition != null) {
                patterns = pathPatternsRequestCondition.getPatternValues();
            }
        }
        return patterns;
    }

    public Map getHandlerMethods() {
        if (this.handlerMethods == null) {
            Map beansOfTypeRequestMappingHandlerMapping = this.applicationContext.getBeansOfType(RequestMappingHandlerMapping.class);
            this.handlerMethods = beansOfTypeRequestMappingHandlerMapping.values().stream().map(AbstractHandlerMethodMapping::getHandlerMethods).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1, LinkedHashMap::new));
        }
        return this.handlerMethods;
    }
}

