/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.airag.common.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class AiragLocalCache {
    private static final Map<String, Cache<String, Object>> CACHE_MAP = new ConcurrentHashMap<String, Cache<String, Object>>();

    public static <T> T get(String cacheType, String key) {
        Cache<String, Object> cache = AiragLocalCache.getCache(cacheType);
        return (T)cache.getIfPresent((Object)key);
    }

    public static void put(String cacheType, String key, Object value) {
        Cache<String, Object> cache = AiragLocalCache.getCache(cacheType);
        cache.put((Object)key, value);
    }

    public static void remove(String cacheType, String key) {
        if (CACHE_MAP.containsKey(cacheType)) {
            Cache<String, Object> cache = CACHE_MAP.get(cacheType);
            cache.invalidate((Object)key);
        }
    }

    public static void clear(String cacheType) {
        if (CACHE_MAP.containsKey(cacheType)) {
            Cache<String, Object> cache = CACHE_MAP.get(cacheType);
            cache.invalidateAll();
        }
    }

    private static Cache<String, Object> getCache(String cacheType) {
        if (!CACHE_MAP.containsKey(cacheType)) {
            Cache cache = CacheBuilder.newBuilder().maximumSize(300L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
            CACHE_MAP.put(cacheType, (Cache<String, Object>)cache);
        }
        return CACHE_MAP.get(cacheType);
    }
}

