/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.tool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

public class RenamePackages {
    static final boolean SAVE_FILE = true;
    static final boolean DONT_SAVE_FILE = false;
    boolean debug = false;
    private String baseDir = "src";
    private String workBaseDir = "null";
    private String existingPkgName = "org.appfuse";
    private String newPkgName;
    private String existingPkgPath;
    private String newPkgPath;
    protected final transient Log log = new SystemStreamLog();
    StringBuffer logOutput = new StringBuffer();
    String[] invalidFileTypes = new String[]{"class", "jar", "jpg", "gif", "png", "ico"};
    private Vector filesets = new Vector();

    public RenamePackages(String newPackage) {
        this.newPkgName = newPackage;
    }

    public void addFileset(FileSet fileset) {
        this.filesets.add(fileset);
    }

    public void setInvalidFileTypes(String invalidFileTypes) {
        this.invalidFileTypes = invalidFileTypes.split(",");
        if (this.debug) {
            this.log.debug((CharSequence)("default invalidFileTypes overriden with [" + invalidFileTypes + "]"));
        }
    }

    public void setBaseDir(String baseDir) {
        if (!new File(baseDir.trim()).exists()) {
            throw new ExceptionInInitializerError("Base dir [" + baseDir.trim() + "] does not exist");
        }
        this.baseDir = this.correctFileSeparators(baseDir.trim());
        if (this.baseDir != null) {
            this.workBaseDir = this.baseDir.endsWith(File.separator) ? this.baseDir.substring(0, this.baseDir.length()) + ".work" : this.baseDir + ".work";
            if (this.debug) {
                this.log.debug((CharSequence)("Set workBaseDir to [" + this.workBaseDir + "]"));
            }
        }
    }

    private void validatePackageName(String packageName) throws ExceptionInInitializerError {
        if (packageName.indexOf("/") != -1) {
            throw new ExceptionInInitializerError("packageName [" + packageName + "] is invalid because it contains slashes");
        }
        if (packageName.indexOf("\\") != -1) {
            throw new ExceptionInInitializerError("packageName [" + packageName + "] is invalid because it contains slashes");
        }
    }

    private String stripUnwantedDots(String packageName) {
        while (packageName.endsWith(".")) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        while (packageName.startsWith(".")) {
            packageName = packageName.substring(1);
        }
        if (this.debug) {
            this.log.debug((CharSequence)("returning stripped package name of [" + packageName + "]"));
        }
        return packageName;
    }

    public void setExistingPkgName(String existingPkgName) throws Exception {
        this.log.info((CharSequence)("existingPkgName came in as [" + existingPkgName + "]"));
        this.existingPkgName = this.stripUnwantedDots(existingPkgName.trim());
        this.validatePackageName(this.existingPkgName);
        if (this.existingPkgName.length() == 0) {
            throw new Exception("Unsupported operation - cannot  repackage from empty package name as would  not know which imports to expand out");
        }
    }

    public void setNewPkgName(String newPkgName) throws Exception {
        this.log.info((CharSequence)("newPkgName came in as [" + newPkgName + "]"));
        this.newPkgName = this.stripUnwantedDots(newPkgName.trim());
        this.validatePackageName(this.newPkgName);
        if (this.newPkgName.length() == 0) {
            throw new Exception("Unimplemented operation");
        }
    }

    private void setPackagePaths() {
        this.existingPkgPath = this.getPackagePath(this.existingPkgName);
        this.newPkgPath = this.getPackagePath(this.newPkgName);
        if (this.debug) {
            this.log.debug((CharSequence)("Set existing package path as [" + this.existingPkgPath + "]"));
            this.log.debug((CharSequence)("Set new package path as [" + this.newPkgPath + "]"));
        }
    }

    private String getPackagePath(String pkgName) {
        String[] pkgNames = pkgName.split("\\.");
        String aPath = "";
        for (int i = 0; i < pkgNames.length; ++i) {
            if (aPath.length() != 0) {
                aPath = aPath + File.separator;
            }
            aPath = aPath + pkgNames[i];
        }
        return aPath;
    }

    private void createDirectory(String directoryName) {
        File dir = new File(directoryName);
        if (!dir.exists()) {
            if (dir.mkdirs()) {
                String message = "Created directory [" + directoryName + "]";
                if (this.debug) {
                    this.log.debug((CharSequence)message);
                }
            } else {
                this.log.error((CharSequence)("Failed to create directory [" + directoryName + "]"));
            }
        }
    }

    private void repackage(String inDirName, String inWorkDirName) throws IOException {
        String[] files;
        if (this.debug) {
            this.log.debug((CharSequence)("Inside repackage inDirName is [" + inDirName + "]"));
            this.log.debug((CharSequence)("Inside repackage inWorkDirName is [" + inWorkDirName + "]"));
        }
        if ((files = new File(inDirName).list()) == null) {
            return;
        }
        if (this.debug) {
            this.log.debug((CharSequence)("There are [" + files.length + "] files in dir [" + inDirName + "]"));
        }
        for (int i = 0; i < files.length; ++i) {
            int existingPathIndexPos;
            if (this.debug) {
                this.log.debug((CharSequence)("file is [" + files[i] + "]"));
            }
            String fileName = inDirName + File.separator + files[i];
            File aFile = new File(fileName);
            if (files[i].equals("CVS")) {
                if (!this.debug) continue;
                this.log.debug((CharSequence)"ignoring CVS dir");
                continue;
            }
            if (aFile.isDirectory()) {
                String newPath;
                if (this.debug) {
                    this.log.debug((CharSequence)("Got a dir [" + fileName + "]"));
                }
                String newDirName = inDirName + File.separator + files[i];
                String newWorkDirName = inWorkDirName + File.separator + files[i];
                if (this.isOldPackageDir(fileName)) {
                    newPath = this.convertOldPackageDirName(fileName);
                    if (this.debug) {
                        this.log.debug((CharSequence)("found old package dir [" + fileName + "] " + "newPath is [" + newPath.toString() + "]"));
                    }
                    this.createDirectory(newPath.toString());
                } else {
                    newPath = this.workBaseDir + fileName.substring(this.baseDir.length());
                    if (this.debug) {
                        this.log.debug((CharSequence)("found dir outside old package [" + fileName + "] " + "newPath is [" + newPath + "]"));
                    }
                    this.createDirectory(newPath);
                }
                if (this.debug) {
                    this.log.debug((CharSequence)("Recursing with [" + newDirName + "]"));
                }
                this.repackage(newDirName, newWorkDirName);
                continue;
            }
            if (this.debug) {
                this.log.debug((CharSequence)("Processing file [" + fileName + "] existingPkgPath is [" + this.existingPkgPath + "]"));
            }
            if ((existingPathIndexPos = fileName.indexOf(this.existingPkgPath)) != -1) {
                if (this.debug) {
                    this.log.debug((CharSequence)("found file with existing package name [" + fileName + "]"));
                }
                String newPath = this.convertOldPackageDirName(fileName.substring(0, fileName.lastIndexOf(File.separator)));
                String newFileName = newPath + fileName.substring(fileName.lastIndexOf(File.separator));
                if (this.debug) {
                    this.log.debug((CharSequence)("creating directory [" + newPath + "]"));
                }
                this.createDirectory(newPath);
                if (this.isValidFileType(fileName)) {
                    String output = this.changePackageNamesInFile(fileName, false);
                    if (this.debug) {
                        this.log.debug((CharSequence)("Saving file [" + fileName + "] to new package directory [" + newFileName + "]"));
                    }
                    this.toFile(newFileName, output);
                    continue;
                }
                if (this.debug) {
                    this.log.debug((CharSequence)("Renaming file non valid file type [" + fileName + "]"));
                }
                if (aFile.renameTo(new File(newFileName))) continue;
                this.log.error((CharSequence)("Failed to rename file [" + fileName + "] to [" + newFileName + "]"));
                continue;
            }
            String newFileName = this.workBaseDir + fileName.substring(this.baseDir.length());
            if (aFile.renameTo(new File(newFileName))) {
                if (!this.debug) continue;
                this.log.debug((CharSequence)("Saved file [" + newFileName + "] to new directory structure"));
                continue;
            }
            this.log.error((CharSequence)("Failed to rename file [" + fileName + "] to [" + newFileName + "] to new directory structure"));
        }
    }

    private void checkSummary(String inDirName) throws IOException {
        String[] files;
        if (this.debug) {
            this.log.debug((CharSequence)("Inside checkSummary inDirName is [" + inDirName + "]"));
        }
        if ((files = new File(inDirName).list()) == null) {
            return;
        }
        if (this.debug) {
            this.log.debug((CharSequence)("There are [" + files.length + "] files in dir [" + inDirName + "]"));
        }
        for (String file : files) {
            String fileName;
            File aFile;
            if (this.debug) {
                this.log.debug((CharSequence)("file is [" + file + "]"));
            }
            if ((aFile = new File(fileName = inDirName + File.separator + file)).isDirectory()) {
                if (this.debug) {
                    this.log.debug((CharSequence)("Got a dir [" + fileName + "]"));
                }
                String newDirName = inDirName + File.separator + file;
                if (this.debug) {
                    this.log.debug((CharSequence)("Recursing with [" + newDirName + "]"));
                }
                this.checkSummary(newDirName);
                continue;
            }
            if (this.debug) {
                this.log.debug((CharSequence)("Checking file [" + fileName + "] existingPkgPath is [" + this.existingPkgPath + "]"));
            }
            if (!this.isValidFileType(fileName) || !this.hasFileOldPathOrPkg(fileName) || !this.debug) continue;
            this.log.debug((CharSequence)("File [" + fileName + "] still has old pkg [" + this.existingPkgPath + "]"));
        }
    }

    private boolean matches(String patternStr, String fileContents) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(fileContents);
        return matcher.matches();
    }

    private boolean hasFileOldPathOrPkg(String fileName) {
        try {
            String fileContents = this.fromFile(fileName);
            String patternStr = this.escape(this.existingPkgPath);
            if (this.matches(patternStr, fileContents)) {
                return true;
            }
            patternStr = this.getUnixPath(this.existingPkgPath);
            if (this.matches(patternStr = this.escape(patternStr), fileContents)) {
                return true;
            }
            patternStr = this.getWindowsPath(this.existingPkgPath);
            patternStr = this.escape(patternStr);
            return this.matches(patternStr, fileContents);
        }
        catch (IOException e) {
            this.log.error((CharSequence)("Error loading fileContents in hasFileOldPathOrPkg [" + e.getMessage() + "]"));
            return false;
        }
    }

    private String convertOldPackageDirName(String dirName) {
        int startExistingPathIndexPos = dirName.indexOf(this.existingPkgPath);
        int endExistingPathIndexPos = startExistingPathIndexPos + this.existingPkgPath.length();
        StringBuffer newPath = new StringBuffer();
        newPath.append(this.workBaseDir);
        if (this.debug) {
            this.log.debug((CharSequence)("startExistingPathIndexPos is [" + startExistingPathIndexPos + "]"));
            this.log.debug((CharSequence)("about to do substring on [" + dirName + "] positions [" + this.baseDir.length() + "] and [" + startExistingPathIndexPos + "]"));
        }
        String firstPartFileName = dirName.substring(this.baseDir.length(), startExistingPathIndexPos);
        if (this.debug) {
            this.log.debug((CharSequence)("firstPartFileName is [" + firstPartFileName + "]"));
        }
        newPath.append(firstPartFileName);
        newPath.append(this.newPkgPath);
        String lastPartFileName = dirName.substring(endExistingPathIndexPos);
        if (this.debug) {
            this.log.debug((CharSequence)("appending lastPartFileName [" + lastPartFileName + "]"));
        }
        newPath.append(lastPartFileName);
        return newPath.toString();
    }

    private boolean isOldPackageDir(String dirName) {
        int existingPathIndexPos;
        if (this.debug) {
            this.log.debug((CharSequence)("inside isOldPackageDir with [" + dirName + "]"));
        }
        if ((existingPathIndexPos = dirName.indexOf(this.existingPkgPath)) != -1) {
            if (this.debug) {
                this.log.debug((CharSequence)("found dir with existing package name [" + dirName + "]"));
            }
            return true;
        }
        if (this.debug) {
            this.log.debug((CharSequence)("dir [" + dirName + "] is not old package dir"));
        }
        return false;
    }

    public String fromFile(String fileName) throws IOException {
        return FileUtils.readFileToString((File)new File(fileName), (String)"UTF-8");
    }

    public void toFile(String fileName, String contents) throws IOException {
        if (this.debug) {
            this.log.debug((CharSequence)("Saving file to fileName [" + fileName + "]"));
        }
        FileUtils.writeStringToFile((File)new File(fileName), (String)contents, (String)"UTF-8");
    }

    private boolean isValidFileType(String fileName) {
        for (int i = 0; i < this.invalidFileTypes.length; ++i) {
            if (!fileName.endsWith(this.invalidFileTypes[i])) continue;
            if (this.debug) {
                this.log.debug((CharSequence)("File [" + fileName + "] will just be moved as it is not a valid type"));
            }
            return false;
        }
        return true;
    }

    private String escape(String str) {
        String newStr = "";
        char[] strArr = str.toCharArray();
        for (int i = 0; i < strArr.length; ++i) {
            if (strArr[i] == '.') {
                newStr = newStr + "\\";
            }
            if (strArr[i] == '\\') {
                newStr = newStr + "\\";
            }
            newStr = newStr + strArr[i];
        }
        if (this.debug) {
            this.log.debug((CharSequence)("escaped str is [" + newStr + "]"));
        }
        return newStr;
    }

    private String changePackagePaths(String fileContents) {
        String output = this.changeWindowsPaths(fileContents);
        output = this.changeUnixPaths(output);
        return output;
    }

    private String changeUnixPaths(String fileContents) {
        String patternStr;
        if (this.debug) {
            this.log.debug((CharSequence)"inside changeUnixPaths");
        }
        if (this.newPkgPath.length() == 0) {
            patternStr = this.getUnixPath(this.existingPkgPath) + "/";
        } else {
            if (this.debug) {
                this.log.debug((CharSequence)("before calling getUnixPath existingPkgPath is [" + this.existingPkgPath + "]"));
            }
            patternStr = this.getUnixPath(this.existingPkgPath);
        }
        if (this.debug) {
            this.log.debug((CharSequence)("patternStr before escaping is [" + patternStr + "]"));
        }
        patternStr = this.escape(patternStr);
        if (this.debug) {
            this.log.debug((CharSequence)("after escaping the search/match string is [" + patternStr + "]"));
            this.log.debug((CharSequence)("newPkgPath is [" + this.newPkgPath + "] about to escape it"));
        }
        String replacementStr = this.escape(this.getUnixPath(this.newPkgPath));
        if (this.debug) {
            this.log.debug((CharSequence)("replacementStr after escaping is [" + replacementStr + "]"));
        }
        return this.performReplacement(fileContents, patternStr, replacementStr);
    }

    private String getWindowsPath(String path) {
        String newStr = "";
        char[] strArr = path.toCharArray();
        for (int i = 0; i < strArr.length; ++i) {
            newStr = strArr[i] == '/' ? newStr + "\\" : newStr + strArr[i];
        }
        if (this.debug) {
            this.log.debug((CharSequence)("escaped str is [" + newStr + "]"));
        }
        return newStr;
    }

    private String getUnixPath(String path) {
        if (this.debug) {
            this.log.debug((CharSequence)("inside getUnixPath with path [" + path + "]"));
        }
        String newStr = "";
        char[] strArr = path.toCharArray();
        for (int i = 0; i < strArr.length; ++i) {
            newStr = strArr[i] == '\\' ? newStr + "/" : newStr + strArr[i];
        }
        if (this.debug) {
            this.log.debug((CharSequence)("escaped str is [" + newStr + "]"));
        }
        return newStr;
    }

    private String changeWindowsPaths(String fileContents) {
        String patternStr;
        if (this.debug) {
            this.log.debug((CharSequence)"inside changeWindowsPaths");
        }
        if (this.newPkgPath.length() == 0) {
            patternStr = this.getWindowsPath(this.existingPkgPath) + "\\";
        } else {
            if (this.debug) {
                this.log.debug((CharSequence)("existingPkgPath is currently [" + this.existingPkgPath + "] before calling getWindowsPath"));
            }
            patternStr = this.getWindowsPath(this.existingPkgPath);
        }
        if (this.debug) {
            this.log.debug((CharSequence)("patternStr is [" + patternStr + "] after calling getWindowsPath"));
        }
        patternStr = this.escape(patternStr);
        if (this.debug) {
            this.log.debug((CharSequence)("After escaping the pattern/search str it is [" + patternStr + "]"));
            this.log.debug((CharSequence)("Before escaping and calling getWindowsPath the newPkgPath it is [" + this.newPkgPath + "]"));
        }
        String replacementStr = this.escape(this.getWindowsPath(this.newPkgPath));
        if (this.debug) {
            this.log.debug((CharSequence)("After escaping it, it is now [" + replacementStr + "]"));
        }
        return this.performReplacement(fileContents, patternStr, replacementStr);
    }

    private String performReplacement(String fileContents, String patternStr, String replacementStr) {
        if (this.debug) {
            this.log.debug((CharSequence)("replacing [" + patternStr + "] with [" + replacementStr + "]"));
        }
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(fileContents);
        String output = matcher.replaceAll(replacementStr);
        return output;
    }

    private String changePackageNames(String fileContents) {
        String patternStr = this.newPkgName.length() == 0 ? this.existingPkgName + "." : this.existingPkgName;
        patternStr = this.escape(patternStr);
        String replacementStr = this.escape(this.newPkgName);
        return this.performReplacement(fileContents, patternStr, replacementStr);
    }

    private String changePackageNamesInFile(String fileName, boolean saveToSameFile) throws IOException {
        if (this.debug) {
            this.log.debug((CharSequence)("calling fromFile with fileName [" + fileName + "]"));
        }
        String inputStr = this.fromFile(fileName);
        String output = this.changePackageNames(inputStr);
        output = this.changePackagePaths(output);
        if (saveToSameFile) {
            if (this.debug) {
                this.log.debug((CharSequence)("replaced package names in file and now saving it to [" + fileName + "]"));
            }
            this.toFile(fileName, output);
        }
        return output;
    }

    private String correctFileSeparators(String fileName) {
        String localSeparator = File.separator;
        if (localSeparator.equals("\\")) {
            return fileName.replace('/', '\\');
        }
        return fileName.replace('\\', '/');
    }

    private void renameOtherFiles() {
        if (this.debug) {
            this.log.debug((CharSequence)"Inside renameOtherFiles");
        }
        try {
            for (FileSet fs : this.filesets) {
                fs.setDir(new File(this.workBaseDir));
                if (this.debug) {
                    this.log.debug((CharSequence)("got fileset fs [" + fs + "]"));
                }
                DirectoryScanner ds = fs.getDirectoryScanner(new Project());
                if (this.debug) {
                    this.log.debug((CharSequence)("ds baseDir is [" + ds.getBasedir().getAbsolutePath() + "]"));
                }
                ds.scan();
                String[] includedFiles = ds.getIncludedFiles();
                if (this.debug) {
                    this.log.debug((CharSequence)("Got includedFiles [" + includedFiles + "]"));
                }
                if (includedFiles != null) {
                    for (int i = 0; i < includedFiles.length; ++i) {
                        this.processOtherFile(includedFiles[i]);
                    }
                    continue;
                }
                if (!this.debug) continue;
                this.log.debug((CharSequence)"Did not find any matching files for one of the filesets");
            }
        }
        catch (Exception e) {
            this.log.error((CharSequence)("Exception at end of renaming other files [" + e.getMessage() + "]"));
        }
    }

    private void processOtherFile(String fileName) {
        try {
            if (this.debug) {
                this.log.debug((CharSequence)("Processing file [" + fileName + "]"));
            }
            if (this.isValidFileType(fileName)) {
                fileName = this.correctFileSeparators(fileName);
                if (this.debug) {
                    this.log.debug((CharSequence)("After correcting file separators fileName is [" + fileName + "]"));
                    this.log.debug((CharSequence)"file is valid so changing package names");
                }
                fileName = this.workBaseDir + File.separator + fileName;
                this.changePackageNamesInFile(fileName, true);
                if (this.debug) {
                    this.log.debug((CharSequence)("processing change package names on other file [" + fileName + "]"));
                }
            } else {
                this.log.error((CharSequence)("Not processing file [" + fileName + "] as it is not a valid type"));
            }
        }
        catch (FileNotFoundException f) {
            this.log.error((CharSequence)("could not find resource from path [" + fileName + "]"));
        }
        catch (IOException e) {
            this.log.error((CharSequence)("IOException when renaming other files [" + e.getMessage() + "]"));
        }
    }

    public void deleteAll(String fileName) {
        File aFile = new File(fileName);
        if (this.debug) {
            this.log.debug((CharSequence)("inside deleteAll with fileName [" + fileName + "]"));
        }
        if (aFile.exists()) {
            boolean isDir = aFile.isDirectory();
            if (isDir) {
                String[] inFiles = aFile.list();
                for (int fileNum = 0; fileNum < inFiles.length; ++fileNum) {
                    String subFileName = fileName + File.separator + inFiles[fileNum];
                    this.deleteAll(subFileName);
                }
            }
            if (this.debug) {
                this.log.debug((CharSequence)("About to delete file inside deleteAll [" + fileName + "]"));
            }
            if (aFile.delete()) {
                if (this.debug) {
                    if (isDir) {
                        this.log.debug((CharSequence)("Deleted dir [" + fileName + "]"));
                    } else {
                        this.log.debug((CharSequence)("Deleted file [" + fileName + "]"));
                    }
                }
            } else {
                this.log.error((CharSequence)("Failed to delete file/dir [" + fileName + "]"));
            }
        }
    }

    private void refactorNonPackageFiles() {
        try {
            String[] extensions = new String[]{"java", "page", "application", "properties", "tld", "xml"};
            Iterator filesInMain = FileUtils.iterateFiles((File)new File(this.workBaseDir), (String[])extensions, (boolean)true);
            while (filesInMain.hasNext()) {
                File f = (File)filesInMain.next();
                this.changePackageNamesInFile(f.getAbsolutePath(), true);
            }
        }
        catch (IOException ioex) {
            this.log.error((CharSequence)("IOException: " + ioex.getMessage()));
        }
    }

    public void execute() {
        try {
            File workBaseDir;
            if (this.newPkgName == null) {
                throw new BuildException("The new package path needs to be set using <renamepackages newPkgName=\"${new.pkg.name}\"");
            }
            if (this.baseDir == null) {
                throw new BuildException("The base directory needs to be set using <renamepackages baseDir=\"${src.base.dir}\"/>\n");
            }
            if (this.debug) {
                this.log.info((CharSequence)("existingPkgName is [" + this.existingPkgName + "]"));
                this.log.info((CharSequence)("newPkgName is [" + this.newPkgName + "]"));
            }
            this.setPackagePaths();
            if (this.debug) {
                this.log.info((CharSequence)"Package paths set");
            }
            this.repackage(this.baseDir, this.workBaseDir);
            if (this.debug) {
                this.log.info((CharSequence)"RePackage directories");
            }
            this.renameOtherFiles();
            if (this.debug) {
                this.log.info((CharSequence)"Rename other files");
            }
            this.refactorNonPackageFiles();
            this.checkSummary(this.workBaseDir);
            if (this.debug) {
                this.log.info((CharSequence)"CheckSummary");
            }
            this.deleteAll(this.baseDir);
            if (this.debug) {
                this.log.info((CharSequence)"Delete all");
            }
            if ((workBaseDir = new File(this.workBaseDir)).renameTo(new File(this.baseDir))) {
                if (this.debug) {
                    this.log.info((CharSequence)"Successfully renamed work dir back to base dir");
                }
            } else {
                this.log.error((CharSequence)"Error could not rename work dir");
            }
            this.deleteOrgPackage("main");
            this.deleteOrgPackage("test");
        }
        catch (IOException ioe) {
            this.log.error((CharSequence)("Caught an IO:" + ioe.getMessage()));
        }
        catch (Exception e) {
            this.log.error((CharSequence)("Uncaught exception caught [" + e.getMessage() + "]"));
        }
        this.log.info((CharSequence)("[AppFuse] Refactored all 'org.appfuse' packages and paths to '" + this.newPkgName + "'."));
    }

    private void deleteOrgPackage(String path) {
        File orgDir = new File(this.baseDir + "/" + path + "/java/org");
        if (orgDir.isDirectory() && orgDir.list().length == 0 && !orgDir.delete()) {
            this.log.warn((CharSequence)("Failed to delete '" + orgDir.getAbsolutePath() + "', please delete manually."));
        }
    }
}

