/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.tool;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Echo;
import org.apache.tools.ant.taskdefs.LoadFile;
import org.apache.tools.ant.taskdefs.Replace;
import org.apache.tools.ant.taskdefs.optional.ReplaceRegExp;
import org.apache.tools.ant.types.FileSet;
import org.appfuse.mojo.installer.AntUtils;
import org.appfuse.tool.StringUtils;

public class ArtifactInstaller {
    private Log log;
    static final String FILE_SEP = System.getProperty("file.separator");
    Project antProject;
    String pojoName;
    String pojoNameLower;
    String destinationDirectory;
    String sourceDirectory;
    MavenProject project;
    boolean genericCore;
    StringUtils util;

    public ArtifactInstaller(MavenProject project, String pojoName, String sourceDirectory, String destinationDirectory, boolean genericCore) {
        this.project = project;
        this.pojoName = pojoName;
        this.pojoNameLower = this.pojoLowerCase(pojoName);
        this.sourceDirectory = sourceDirectory;
        this.destinationDirectory = destinationDirectory;
        this.genericCore = genericCore;
        this.util = new StringUtils();
    }

    public void execute() {
        this.antProject = AntUtils.createProject();
        boolean hasDbUnit = this.projectContainsPluginArtifact("dbunit");
        if (hasDbUnit) {
            this.log("Installing sample data for DbUnit...");
            this.installSampleData();
        }
        if (this.project.getPackaging().equals("jar") || this.project.getPackaging().equals("war") && this.project.getParent() == null) {
            this.copyGeneratedObjects(this.sourceDirectory, this.destinationDirectory, "**/model/**/*.java");
            this.copyGeneratedObjects(this.sourceDirectory, this.destinationDirectory, "**/dao/**/*.java");
            this.copyGeneratedObjects(this.sourceDirectory, this.destinationDirectory, "**/service/**/*.java");
            if (this.genericCore) {
                this.log("Installing Spring bean definitions (genericCore == true)...");
                this.installGenericBeanDefinitions();
            }
            this.installiBATISFiles();
        }
        if (this.project.getPackaging().equalsIgnoreCase("war")) {
            this.copyGeneratedObjects(this.sourceDirectory, this.destinationDirectory, "**/webapp/**/*.java");
            String webFramework = this.project.getProperties().getProperty("web.framework");
            if ("jsf".equalsIgnoreCase(webFramework)) {
                this.log("Installing JSF views and configuring...");
                this.installJSFNavigationAndBeans();
                this.installJSFViews();
            } else if ("struts".equalsIgnoreCase(webFramework)) {
                this.log("Installing Struts views and configuring...");
                this.installStrutsActionDefinitions();
                this.copyGeneratedObjects(this.sourceDirectory + "/src/main/resources", this.destinationDirectory + "/src/main/resources", "**/model/*.xml");
                this.copyGeneratedObjects(this.sourceDirectory + "/src/main/resources", this.destinationDirectory + "/src/main/resources", "**/webapp/action/*.xml");
                this.installStrutsViews();
            } else if ("spring".equalsIgnoreCase(webFramework)) {
                this.log("Installing Spring views and configuring...");
                this.installSpringValidation();
                this.installSpringViews();
            } else if ("tapestry".equalsIgnoreCase(webFramework)) {
                this.log("Installing Tapestry views and configuring...");
                this.installTapestryViews();
            }
            this.log("Installing i18n messages...");
            this.installInternationalizationKeys(webFramework);
            this.log("Installing menu...");
            this.installMenu();
            this.log("Installing UI tests...");
            this.installUITests();
        }
    }

    private boolean projectContainsPluginArtifact(String artifactId) {
        for (Object artifact : this.project.getPluginArtifacts()) {
            if (!((Artifact)artifact).getArtifactId().contains(artifactId)) continue;
            return true;
        }
        return false;
    }

    private boolean projectContainsArtifact(String artifactId) {
        for (Object artifact : this.project.getArtifacts()) {
            if (!((Artifact)artifact).getArtifactId().contains(artifactId)) continue;
            return true;
        }
        return false;
    }

    protected void copyGeneratedObjects(String inSourceDirectory, String inDestinationDirectory, String inPattern) {
        Copy copyTask = (Copy)this.antProject.createTask("copy");
        FileSet fileSet = AntUtils.createFileset(inSourceDirectory, inPattern, new ArrayList());
        this.log("Installing generated files (pattern: " + inPattern + ")...");
        copyTask.setTodir(new File(inDestinationDirectory));
        copyTask.addFileset(fileSet);
        copyTask.execute();
    }

    private String pojoLowerCase(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    private String getPathToApplicationContext() {
        if (this.project.getPackaging().equalsIgnoreCase("war")) {
            return "/src/main/webapp/WEB-INF/applicationContext.xml";
        }
        return "/src/main/resources/applicationContext.xml";
    }

    private void installSampleData() {
        this.createLoadFileTask("src/test/resources/" + this.pojoName + "-sample-data.xml", "sample.data").execute();
        File existingFile = new File(this.destinationDirectory + "/src/test/resources/sample-data.xml");
        this.parseXMLFile(existingFile, null, "</dataset>", "sample.data");
    }

    private void installiBATISFiles() {
        if (this.project.getProperties().getProperty("dao.framework").equals("ibatis")) {
            this.log("Installing iBATIS SQL Maps...");
            this.createLoadFileTask("src/main/resources/" + this.pojoName + "-sql-map-config.xml", "sql.map.config").execute();
            File sqlMapConfig = new File(this.destinationDirectory + "/src/main/resources/sql-map-config.xml");
            this.parseXMLFile(sqlMapConfig, null, "</sqlMapConfig>", "sql.map.config");
            File sqlMapsDir = new File(this.destinationDirectory + "/src/main/resources/sqlmaps");
            if (sqlMapsDir.exists()) {
                sqlMapsDir.mkdir();
            }
            Copy copy = (Copy)this.antProject.createTask("copy");
            copy.setFile(new File(this.sourceDirectory + "/src/main/resources/sqlmaps/" + this.pojoName + "SQL.xml"));
            copy.setTodir(new File(this.destinationDirectory + "/src/main/resources/sqlmaps"));
            copy.execute();
            File ctx = new File(this.destinationDirectory + "/src/main/webapp/WEB-INF/applicationContext.xml");
            try {
                File appCtx = new File(this.destinationDirectory + "/src/main/webapp/WEB-INF/applicationContext.xml");
                String appCtxAsString = FileUtils.readFileToString((File)ctx);
                if (!appCtxAsString.contains("SqlMapClientGpsDevice")) {
                    this.log("Adding compassGps bean to applicationContext.xml");
                    this.createLoadFileTask("src/main/resources/compass-gps.xml", "compass.gps").execute();
                    this.parseXMLFile(appCtx, null, "<!-- Add new DAOs here -->", "compass.gps");
                }
                if (!appCtxAsString.contains("<value>get" + this.pojoName)) {
                    this.createLoadFileTask("src/main/resources/" + this.pojoName + "-select-ids.xml", "select.ids").execute();
                    this.parseXMLFile(appCtx, null, "<value>getUsers</value>", "select.ids");
                }
            }
            catch (IOException e) {
                this.log("Failed to read project's applicationContext.xml!");
                e.printStackTrace();
            }
        }
    }

    private void installGenericBeanDefinitions() {
        this.createLoadFileTask("src/main/resources/" + this.pojoName + "-generic-beans.xml", "context.file").execute();
        File generatedFile = new File(this.destinationDirectory + this.getPathToApplicationContext());
        this.parseXMLFile(generatedFile, this.pojoName + "Manager", "<!-- Add new Managers here -->", "context.file");
    }

    private void installJSFNavigationAndBeans() {
        this.createLoadFileTask("src/main/webapp/WEB-INF/" + this.pojoName + "-navigation.xml", "navigation.rules").execute();
        File generatedFile = new File(this.destinationDirectory + "/src/main/webapp/WEB-INF/faces-config.xml");
        this.parseXMLFile(generatedFile, this.pojoName + "-nav", "<!-- Add additional rules here -->", "navigation.rules");
    }

    private void installSpringControllerBeanDefinitions() {
    }

    private void installSpringValidation() {
        this.createLoadFileTask("src/main/webapp/WEB-INF/" + this.pojoName + "-validation.xml", "spring.validation").execute();
        File generatedFile = new File(this.destinationDirectory + "/src/main/webapp/WEB-INF/validation.xml");
        this.parseXMLFile(generatedFile, this.pojoName, "    </formset>", "spring.validation");
    }

    private void installStrutsActionDefinitions() {
        this.createLoadFileTask("src/main/resources/" + this.pojoName + "-struts.xml", "struts.file").execute();
        File existingFile = new File(this.destinationDirectory + "/src/main/resources/struts.xml");
        this.parseXMLFile(existingFile, this.pojoName + "Action", "<!-- Add additional actions here -->", "struts.file");
    }

    private void installJSFViews() {
        Copy copy = (Copy)this.antProject.createTask("copy");
        copy.setFile(new File(this.sourceDirectory + "/src/main/webapp/" + this.pojoName + "Form.xhtml"));
        copy.setTofile(new File(this.destinationDirectory + "/src/main/webapp/" + this.pojoNameLower + "Form.xhtml"));
        copy.execute();
        copy.setFile(new File(this.sourceDirectory + "/src/main/webapp/" + this.pojoName + "s.xhtml"));
        copy.setTofile(new File(this.destinationDirectory + "/src/main/webapp/" + this.util.getPluralForWord(this.pojoNameLower) + ".xhtml"));
        copy.execute();
    }

    private void installSpringViews() {
        Copy copy = (Copy)this.antProject.createTask("copy");
        copy.setFile(new File(this.sourceDirectory + "/src/main/webapp/WEB-INF/pages/" + this.pojoName + "form.jsp"));
        copy.setTofile(new File(this.destinationDirectory + "/src/main/webapp/WEB-INF/pages/" + this.pojoNameLower + "form.jsp"));
        copy.execute();
        copy.setFile(new File(this.sourceDirectory + "/src/main/webapp/WEB-INF/pages/" + this.pojoName + "s.jsp"));
        copy.setTofile(new File(this.destinationDirectory + "/src/main/webapp/WEB-INF/pages/" + this.util.getPluralForWord(this.pojoNameLower) + ".jsp"));
        copy.execute();
    }

    private void installStrutsViews() {
        Copy copy = (Copy)this.antProject.createTask("copy");
        copy.setFile(new File(this.sourceDirectory + "/src/main/webapp/WEB-INF/pages/" + this.pojoName + "Form.jsp"));
        copy.setTofile(new File(this.destinationDirectory + "/src/main/webapp/WEB-INF/pages/" + this.pojoNameLower + "Form.jsp"));
        copy.execute();
        copy.setFile(new File(this.sourceDirectory + "/src/main/webapp/WEB-INF/pages/" + this.pojoName + "List.jsp"));
        copy.setTofile(new File(this.destinationDirectory + "/src/main/webapp/WEB-INF/pages/" + this.pojoNameLower + "List.jsp"));
        copy.execute();
    }

    private void installTapestryViews() {
        Copy copy = (Copy)this.antProject.createTask("copy");
        copy.setFile(new File(this.sourceDirectory + "/src/main/webapp/" + this.pojoName + "Form.tml"));
        copy.setTodir(new File(this.destinationDirectory + "/src/main/webapp"));
        copy.execute();
        copy.setFile(new File(this.sourceDirectory + "/src/main/webapp/" + this.pojoName + "List.tml"));
        copy.execute();
    }

    private void installMenu() {
        File menuConfig = new File(this.destinationDirectory + "/src/main/webapp/WEB-INF/menu-config.xml");
        boolean hasStrutsMenu = menuConfig.exists();
        if (hasStrutsMenu) {
            this.createLoadFileTask("src/main/webapp/common/" + this.pojoName + "-menu.jsp", "menu.jsp").execute();
            File existingFile = new File(this.destinationDirectory + "/src/main/webapp/common/menu.jsp");
            this.parseXMLFile(existingFile, this.pojoName, "</ul>", "menu.jsp");
            this.createLoadFileTask("src/main/webapp/WEB-INF/" + this.pojoName + "-menu-config.xml", "menu.config").execute();
            existingFile = new File(this.destinationDirectory + "/src/main/webapp/WEB-INF/menu-config.xml");
            this.parseXMLFile(existingFile, this.pojoName, "    </Menus>", "menu.config");
        } else {
            this.createLoadFileTask("src/main/webapp/common/" + this.pojoName + "-menu-light.jsp", "menu-light.jsp").execute();
            File existingFile = new File(this.destinationDirectory + "/src/main/webapp/decorators/default.jsp");
            this.parseXMLFile(existingFile, this.pojoName, "<!-- Add new menu items here -->", "menu-light.jsp");
        }
    }

    private void installInternationalizationKeys(String webFramework) {
        this.createLoadFileTask("src/main/resources/" + this.pojoName + "-ApplicationResources.properties", "i18n.file").execute();
        File existingFile = new File(this.destinationDirectory + "/src/main/resources/ApplicationResources.properties");
        if (!existingFile.exists()) {
            existingFile = new File(this.destinationDirectory + "/src/main/resources/messages.properties");
        }
        this.parsePropertiesFile(existingFile, this.pojoName);
        Echo echoTask = (Echo)this.antProject.createTask("echo");
        echoTask.setFile(existingFile);
        echoTask.setAppend(true);
        echoTask.setMessage(this.antProject.getProperty("i18n.file"));
        echoTask.execute();
    }

    private void installUITests() {
        boolean webTestsExist = new File("src/test/resources/" + this.pojoName + "-web-tests.xml").exists();
        File existingFile = new File(this.destinationDirectory + "/src/test/resources/web-tests.xml");
        if (webTestsExist && existingFile.exists()) {
            this.createLoadFileTask("src/test/resources/" + this.pojoName + "-web-tests.xml", "web.tests").execute();
            this.parseXMLFile(existingFile, this.pojoName, "</project>", "web.tests");
            Replace replace = (Replace)this.antProject.createTask("replace");
            replace.setFile(existingFile);
            try {
                if (FileUtils.readFileToString((File)existingFile).contains("FileUpload")) {
                    replace.setToken(",FileUpload");
                    replace.setValue(",FileUpload," + this.pojoName + "Tests");
                } else {
                    replace.setToken("depends=\"UserTests");
                    replace.setValue("depends=\"UserTests," + this.pojoName + "Tests");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            replace.execute();
        } else {
            this.log("Project doesn't use Canoo WebTest, disabling UI test generation.");
            this.log("Support for jWebUnit will be added in a future release.");
            this.log("See http://issues.appfuse.org/browse/EQX-215 for more information.");
        }
    }

    protected LoadFile createLoadFileTask(String inFile, String propName) {
        inFile = this.sourceDirectory + FILE_SEP + inFile;
        LoadFile loadFileTask = (LoadFile)this.antProject.createTask("loadfile");
        loadFileTask.init();
        loadFileTask.setProperty(propName);
        loadFileTask.setSrcFile(new File(inFile));
        return loadFileTask;
    }

    private void parseXMLFile(File existingFile, String beanName, String tokenToReplace, String fileVariable) {
        String nameInComment = beanName;
        if (beanName == null) {
            nameInComment = this.pojoName;
        }
        Replace replace1 = (Replace)this.antProject.createTask("replace");
        replace1.setFile(existingFile);
        replace1.setToken("<!--" + nameInComment + "-START-->");
        replace1.setValue("REGULAR-START");
        replace1.execute();
        Replace replace2 = (Replace)this.antProject.createTask("replace");
        replace2.setFile(existingFile);
        replace2.setToken("<!--" + nameInComment + "-END-->");
        replace2.setValue("REGULAR-END");
        replace2.execute();
        ReplaceRegExp regExpTask = (ReplaceRegExp)this.antProject.createTask("replaceregexp");
        regExpTask.setFile(existingFile);
        regExpTask.setMatch("REGULAR-START(?s:.)*REGULAR-END");
        regExpTask.setReplace("");
        regExpTask.setFlags("g");
        regExpTask.execute();
        Replace replaceData = (Replace)this.antProject.createTask("replace");
        replaceData.setFile(existingFile);
        replaceData.setToken(tokenToReplace);
        String stringWithProperLineEndings = ArtifactInstaller.adjustLineEndingsForOS(this.antProject.getProperty(fileVariable));
        replaceData.setValue(stringWithProperLineEndings);
        replaceData.execute();
    }

    private void parsePropertiesFile(File existingFile, String beanName) {
        String nameInComment = beanName;
        if (beanName == null) {
            nameInComment = this.pojoName;
        }
        Replace replace1 = (Replace)this.antProject.createTask("replace");
        replace1.setFile(existingFile);
        replace1.setToken("# -- " + nameInComment + "-START");
        replace1.setValue("REGULAR-START");
        replace1.execute();
        Replace replace2 = (Replace)this.antProject.createTask("replace");
        replace2.setFile(existingFile);
        replace2.setToken("# -- " + nameInComment + "-END");
        replace2.setValue("REGULAR-END");
        replace2.execute();
        ReplaceRegExp regExpTask = (ReplaceRegExp)this.antProject.createTask("replaceregexp");
        regExpTask.setFile(existingFile);
        regExpTask.setMatch("REGULAR-START(?s:.)*REGULAR-END");
        regExpTask.setReplace("");
        regExpTask.setFlags("g");
        regExpTask.execute();
    }

    private static String adjustLineEndingsForOS(String property) {
        String os = System.getProperty("os.name");
        if (os.startsWith("Linux") || os.startsWith("Mac")) {
            property = property.replaceAll("\r", "");
        } else if (os.startsWith("Windows")) {
            property = property.replaceAll(">\n", ">\r\n");
        }
        return property;
    }

    private void log(String msg) {
        this.getLog().info((CharSequence)("[AppFuse] " + msg));
    }

    public Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setGenericCore(boolean genericCore) {
        this.genericCore = genericCore;
    }
}

