/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.mojo.installer;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.embedder.MavenEmbedderConsoleLogger;
import org.apache.maven.embedder.MavenEmbedderLogger;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Get;
import org.apache.tools.ant.taskdefs.LoadFile;
import org.apache.tools.ant.taskdefs.Move;
import org.apache.tools.ant.types.FileSet;
import org.appfuse.mojo.installer.AntUtils;
import org.appfuse.tool.RenamePackages;
import org.appfuse.tool.SubversionUtils;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallSourceMojo
extends AbstractMojo {
    private static final String APPFUSE_GROUP_ID = "org.appfuse";
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String LINE_SEP = System.getProperty("line.separator");
    Project antProject = AntUtils.createProject();
    Properties appfuseProperties;
    private static final ThreadLocal<Map> propertiesContextHolder = new ThreadLocal();
    private String destinationDirectory;
    private String trunk;
    private String tag;
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean modular;
        String daoFramework;
        System.setProperty("file.encoding", "UTF-8");
        String appfuseVersion = this.project.getProperties().getProperty("appfuse.version");
        if (appfuseVersion != null && !appfuseVersion.endsWith("SNAPSHOT") && this.tag.equals("trunk/")) {
            this.tag = "tags/APPFUSE_" + appfuseVersion.toUpperCase().replaceAll("-", "_") + "/";
            if (this.tag.contains("_M")) {
                this.tag = this.tag.replace("_M", "-M");
            } else if (this.tag.contains("_R")) {
                this.tag = this.tag.replace("_R", "-R");
            }
        }
        if ((daoFramework = this.project.getProperties().getProperty("dao.framework")) == null) {
            this.log("No dao.framework property specified, defaulting to 'hibernate'");
        }
        String webFramework = this.project.getProperties().getProperty("web.framework");
        boolean bl = modular = this.project.getPackaging().equals("pom") && !this.project.hasParent();
        if (this.project.getPackaging().equals("jar") || this.project.getPackaging().equals("war") && !this.project.hasParent()) {
            this.log("Installing source from data-common module...");
            this.export("data/common/src", modular ? "core/src" : this.destinationDirectory);
            this.log("Installing source from " + daoFramework + " module...");
            this.export("data/" + daoFramework + "/src", modular ? "core/src" : this.destinationDirectory);
            this.log("Installing source from service module...");
            this.export("service/src", modular ? "core/src" : this.destinationDirectory);
            this.moveFiles(modular ? "core/src/main" : this.destinationDirectory + "/main", modular ? "core/src/test" : this.destinationDirectory + "/test", "**/Base*TestCase.java");
            this.deleteFile("test/resources/hibernate.cfg.xml");
            this.deleteFile("test/resources/META-INF");
            this.deleteFile("test/resources/sql-map-config.xml");
            if ("jpa".equalsIgnoreCase(daoFramework)) {
                this.deleteFile("main/resources/hibernate.cfg.xml");
            }
        }
        boolean isWebServicesProject = false;
        for (Object pluginArtifact : this.project.getPluginArtifacts()) {
            if (!((Artifact)pluginArtifact).getArtifactId().contains("enunciate")) continue;
            isWebServicesProject = true;
            break;
        }
        if (this.project.getPackaging().equalsIgnoreCase("war")) {
            if (webFramework == null && !isWebServicesProject) {
                this.getLog().error((CharSequence)"The web.framework property is not specified - please modify your pom.xml to add  this property. For example: <web.framework>struts</web.framework>.");
                throw new MojoExecutionException("No web.framework property specified, please modify pom.xml to add it.");
            }
            if (this.project.hasParent()) {
                this.deleteFile("main/resources/hibernate.cfg.xml");
                this.deleteFile("main/resources/META-INF");
                this.deleteFile("main/resources/sql-map-config.xml");
                this.deleteFile("test/resources/jdbc.properties");
            } else if (!this.isAppFuse()) {
                this.deleteFile("test/resources/jdbc.properties");
            }
        }
        this.log("Source successfully exported, modifying pom.xml...");
        List dependencies = this.project.getOriginalModel().getDependencies();
        List<Dependency> newDependencies = new ArrayList<Dependency>();
        for (Object dependency : dependencies) {
            Dependency dep = (Dependency)dependency;
            if (dep.getGroupId().equals(APPFUSE_GROUP_ID)) continue;
            newDependencies.add(dep);
        }
        if (!this.project.getPackaging().equals("pom") && !this.project.hasParent()) {
            newDependencies = this.addModuleDependencies(newDependencies, "root", "");
            newDependencies = this.addModuleDependencies(newDependencies, "data", "data");
            newDependencies = this.addModuleDependencies(newDependencies, "data-common", "data/common");
            newDependencies = this.addModuleDependencies(newDependencies, daoFramework, "data/" + daoFramework);
            newDependencies = this.addModuleDependencies(newDependencies, "service", "service");
            if (!isWebServicesProject && this.project.getPackaging().equals("war")) {
                newDependencies = this.addWebDependencies(appfuseVersion, newDependencies, webFramework);
            }
            this.createFullSourcePom(newDependencies);
        } else {
            if (this.project.getPackaging().equals("pom")) {
                newDependencies = this.addModuleDependencies(newDependencies, "root", "");
                this.createFullSourcePom(newDependencies);
            }
            if (this.project.getPackaging().equals("jar")) {
                newDependencies.clear();
                newDependencies = this.addModuleDependencies(newDependencies, "data", "data");
                newDependencies = this.addModuleDependencies(newDependencies, "data-common", "data/common");
                newDependencies = this.addModuleDependencies(newDependencies, daoFramework, "data/" + daoFramework);
                newDependencies = this.addModuleDependencies(newDependencies, "service", "service");
                this.createFullSourcePom(newDependencies);
            }
            if (this.project.getPackaging().equals("war")) {
                newDependencies.clear();
                newDependencies = this.addWebDependencies(appfuseVersion, newDependencies, webFramework);
                this.createFullSourcePom(newDependencies);
            }
        }
    }

    private List<Dependency> addWebDependencies(String appfuseVersion, List<Dependency> newDependencies, String webFramework) {
        newDependencies = this.addModuleDependencies(newDependencies, "web", "web");
        Double appfuseVersionAsDouble = new Double(appfuseVersion.substring(0, appfuseVersion.lastIndexOf(".")));
        this.getLog().debug((CharSequence)("Detected AppFuse version: " + appfuseVersionAsDouble));
        if (this.isAppFuse() && appfuseVersionAsDouble < 2.1) {
            newDependencies = this.addModuleDependencies(newDependencies, "web-common", "web/common");
        }
        if (this.isAppFuse() && this.project.getPackaging().equals("war") && this.project.hasParent()) {
            newDependencies = this.addModuleDependencies(newDependencies, "web-common", "web/common");
            newDependencies = this.addModuleDependencies(newDependencies, webFramework, "web/" + webFramework);
        }
        return newDependencies;
    }

    private boolean isAppFuse() {
        return this.project.getProperties().getProperty("copyright.year") != null;
    }

    private void deleteFile(String filePath) {
        if (!filePath.startsWith("/")) {
            filePath = "/" + filePath;
        }
        File duplicateFile = new File(this.getFilePath(this.destinationDirectory + filePath));
        try {
            this.getLog().debug((CharSequence)("Looking for duplicate file at '" + duplicateFile.getCanonicalPath()));
            if (duplicateFile.exists()) {
                this.getLog().debug((CharSequence)("Deleting duplicate file at '" + duplicateFile.getCanonicalPath()));
                if (duplicateFile.isDirectory()) {
                    FileUtils.deleteDirectory((File)duplicateFile);
                } else {
                    FileUtils.forceDeleteOnExit((File)duplicateFile);
                }
            }
        }
        catch (IOException io) {
            this.getLog().error((CharSequence)("Failed to delete '" + filePath + "', please delete manually."));
        }
    }

    private void createFullSourcePom(List<Dependency> newDependencies) throws MojoFailureException {
        File pom;
        TreeSet<String> projectProperties = new TreeSet<String>();
        for (Dependency dep : newDependencies) {
            String version;
            if (dep.getArtifactId().equals("spring-test") || dep.getArtifactId().contains("jmock") || dep.getArtifactId().equals("junit") || dep.getArtifactId().equals("shale-test")) {
                dep.setOptional(true);
                dep.setScope(null);
            }
            if ((version = dep.getVersion()).startsWith("${")) {
                version = version.substring(2);
            }
            if (version.endsWith("}")) {
                version = version.substring(0, version.length() - 1);
            }
            projectProperties.add(version);
        }
        if (this.project.getPackaging().equals("war") && this.project.hasParent()) {
            Dependency core = new Dependency();
            core.setGroupId("${project.parent.groupId}");
            core.setArtifactId("core");
            core.setVersion("${project.parent.version}");
            newDependencies.add(core);
            if (this.project.getProperties().getProperty("web.framework").equals("jsf")) {
                Dependency jsp21 = new Dependency();
                jsp21.setGroupId("javax.servlet.jsp");
                jsp21.setArtifactId("jsp-api");
                jsp21.setVersion("${jsp.version}");
                jsp21.setScope("provided");
                newDependencies.add(jsp21);
                this.project.getOriginalModel().getProperties().setProperty("jsp.version", "2.1");
            }
        }
        Collections.sort(newDependencies, new BeanComparator("groupId"));
        this.project.getOriginalModel().setDependencies(newDependencies);
        Properties currentProperties = this.project.getOriginalModel().getProperties();
        LinkedHashSet<String> currentKeys = new LinkedHashSet<String>();
        for (Object key : currentProperties.keySet()) {
            currentKeys.add((String)key);
        }
        StringBuffer sortedProperties = new StringBuffer();
        Properties appfuseProperties = this.getAppFuseProperties();
        LinkedHashMap<String, String> propertiesForPom = new LinkedHashMap<String, String>();
        for (String key : projectProperties) {
            String value;
            if (currentKeys.contains(key) || (value = appfuseProperties.getProperty(key)) == null) continue;
            if ("tapestry".equals(this.project.getProperties().getProperty("web.framework")) && key.equals("commons.dbcp.version")) {
                value = "1.2.2";
            }
            if (value.contains("&amp;")) {
                value = "<![CDATA[" + value + "]]>";
            }
            sortedProperties.append("        <").append(key).append(">").append(value).append("</").append(key).append(">\n");
            propertiesForPom.put(key, value);
        }
        if (this.project.getPackaging().equals("pom") || this.project.hasParent()) {
            LinkedHashMap properties = new LinkedHashMap();
            if (propertiesContextHolder.get() != null) {
                properties = (LinkedHashMap)propertiesContextHolder.get();
            }
            for (String key : propertiesForPom.keySet()) {
                if (properties.containsKey(key)) continue;
                properties.put(key, propertiesForPom.get(key));
            }
            propertiesContextHolder.set(properties);
        }
        StringWriter writer = new StringWriter();
        try {
            this.project.writeOriginalModel((Writer)writer);
            File pom2 = new File("pom-fullsource.xml");
            if (pom2.exists()) {
                pom2.delete();
            }
            FileWriter fw = new FileWriter(pom2);
            fw.write(writer.toString());
            fw.flush();
            fw.close();
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)("Unable to create pom-fullsource.xml: " + ex.getMessage()), (Throwable)ex);
            throw new MojoFailureException(ex.getMessage());
        }
        this.log("Updated dependencies in pom.xml...");
        String pomXml = writer.toString();
        int startTag = pomXml.indexOf("\n  <dependencies>");
        String dependencyXml = pomXml.substring(startTag, pomXml.indexOf("</dependencies>", startTag));
        dependencyXml = dependencyXml.replaceAll("  ", "    ");
        dependencyXml = "\n    <!-- Dependencies calculated by AppFuse when running full-source plugin -->" + dependencyXml;
        try {
            String packaging = this.project.getPackaging();
            String pathToPom = "pom.xml";
            if (this.project.hasParent()) {
                if (packaging.equals("jar")) {
                    pathToPom = "core/" + pathToPom;
                } else if (packaging.equals("war")) {
                    pathToPom = "web/" + pathToPom;
                }
            }
            String originalPom = FileUtils.readFileToString((File)new File(pathToPom), (String)"UTF-8");
            originalPom = originalPom.replace("\t", "    ");
            startTag = originalPom.indexOf("\n    <dependencies>");
            StringBuffer sb = new StringBuffer();
            sb.append(originalPom.substring(0, startTag));
            sb.append(dependencyXml);
            sb.append(originalPom.substring(originalPom.indexOf("</dependencies>", startTag)));
            String adjustedPom = sb.toString();
            if (!this.project.getPackaging().equals("pom") && !this.project.hasParent()) {
                adjustedPom = InstallSourceMojo.addPropertiesToPom(adjustedPom, sortedProperties);
            }
            adjustedPom = InstallSourceMojo.adjustLineEndingsForOS(adjustedPom);
            FileUtils.writeStringToFile((File)new File(pathToPom), (String)adjustedPom, (String)"UTF-8");
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)("Unable to write to pom.xml: " + ex.getMessage()), (Throwable)ex);
            throw new MojoFailureException(ex.getMessage());
        }
        boolean renamePackages = true;
        if (System.getProperty("renamePackages") != null) {
            renamePackages = Boolean.valueOf(System.getProperty("renamePackages"));
        }
        if (renamePackages && !this.project.getPackaging().equals("pom")) {
            this.log("Renaming packages to '" + this.project.getGroupId() + "'...");
            RenamePackages renamePackagesTool = new RenamePackages(this.project.getGroupId());
            if (this.project.hasParent()) {
                if (this.project.getPackaging().equals("jar")) {
                    renamePackagesTool.setBaseDir("core/src");
                } else {
                    renamePackagesTool.setBaseDir("web/src");
                }
            }
            renamePackagesTool.execute();
        }
        if (this.project.getPackaging().equals("war") && this.project.hasParent()) {
            Map properties = propertiesContextHolder.get();
            TreeSet propertiesToAdd = new TreeSet(properties.keySet());
            StringBuffer calculatedProperties = new StringBuffer();
            for (String key : propertiesToAdd) {
                Set<Object> keysInProject = this.project.getParent().getOriginalModel().getProperties().keySet();
                if (keysInProject.contains(key)) continue;
                String value = this.getAppFuseProperties().getProperty(key);
                if (value.contains("&amp;")) {
                    value = "<![CDATA[" + value + "]]>";
                }
                calculatedProperties.append("        <");
                calculatedProperties.append(key);
                calculatedProperties.append(">");
                calculatedProperties.append(value);
                calculatedProperties.append("</");
                calculatedProperties.append(key);
                calculatedProperties.append(">");
                calculatedProperties.append("\n");
            }
            try {
                String originalPom = FileUtils.readFileToString((File)new File("pom.xml"), (String)"UTF-8");
                originalPom = originalPom.replaceAll("  <modules>", "");
                originalPom = originalPom.replaceAll("    <module>.*?</module>", "");
                originalPom = originalPom.replaceAll("  </modules>", "");
                originalPom = originalPom.replace("<repositories>", "<modules>\n        <module>core</module>\n        <module>web</module>\n    </modules>\n\n    <repositories>");
                String pomWithProperties = InstallSourceMojo.addPropertiesToPom(originalPom, calculatedProperties);
                FileUtils.writeStringToFile((File)new File("pom.xml"), (String)pomWithProperties, (String)"UTF-8");
            }
            catch (IOException ex) {
                this.getLog().error((CharSequence)("Unable to read root pom.xml: " + ex.getMessage()), (Throwable)ex);
                throw new MojoFailureException(ex.getMessage());
            }
        }
        if ((pom = new File("pom-fullsource.xml")).exists()) {
            pom.delete();
        }
    }

    private static String addPropertiesToPom(String existingPomXmlAsString, StringBuffer sortedProperties) {
        String adjustedPom = existingPomXmlAsString;
        adjustedPom = adjustedPom.replace("<jdbc.password/>", "<jdbc.password/>" + LINE_SEP + LINE_SEP + "        <!-- Properties calculated by AppFuse when running full-source plugin -->\n" + sortedProperties);
        adjustedPom = adjustedPom.replace("<jdbc.password></jdbc.password>", "<jdbc.password/>" + LINE_SEP + LINE_SEP + "        <!-- Properties calculated by AppFuse when running full-source plugin -->\n" + sortedProperties);
        adjustedPom = adjustedPom.replaceAll("<amp.fullSource>false</amp.fullSource>", "<amp.fullSource>true</amp.fullSource>");
        return InstallSourceMojo.adjustLineEndingsForOS(adjustedPom);
    }

    private static String adjustLineEndingsForOS(String adjustedPom) {
        String os = System.getProperty("os.name");
        if (os.startsWith("Linux") || os.startsWith("Mac")) {
            adjustedPom = adjustedPom.replaceAll("\r", "");
        } else if (os.startsWith("Windows")) {
            adjustedPom = adjustedPom.replaceAll(">\n", ">\r\n");
        }
        return adjustedPom;
    }

    private Properties getAppFuseProperties() {
        if (this.appfuseProperties == null) {
            File pom = new File("target/appfuse-root/pom.xml");
            this.appfuseProperties = this.createProjectFromPom(pom).getOriginalModel().getProperties();
        }
        return this.appfuseProperties;
    }

    private String getFilePath(String s) {
        s = s.replace("/", FILE_SEP);
        return s;
    }

    private void export(String url, String destinationDirectory) throws MojoExecutionException {
        SubversionUtils svn = new SubversionUtils(this.trunk + this.tag + url, destinationDirectory);
        try {
            svn.export();
        }
        catch (SVNException e) {
            for (SVNErrorMessage err = e.getErrorMessage(); err != null; err = err.getChildErrorMessage()) {
                this.getLog().error((CharSequence)(err.getErrorCode().getCode() + " : " + err.getMessage()));
            }
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private void log(String msg) {
        this.getLog().info((CharSequence)("[AppFuse] " + msg));
    }

    private List<Dependency> addModuleDependencies(List<Dependency> dependencies, String moduleName, String moduleLocation) {
        this.log("Adding dependencies from " + moduleName + " module...");
        URL pomLocation = null;
        File newDir = new File("target", "appfuse-" + moduleName);
        if (!newDir.exists()) {
            newDir.mkdirs();
        }
        File pom = new File("target/appfuse-" + moduleName + "/pom.xml");
        try {
            pomLocation = new URL(this.trunk + this.tag + moduleLocation + "/pom.xml");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        Get get = (Get)AntUtils.createProject().createTask("get");
        get.setSrc(pomLocation);
        get.setDest(pom);
        get.setUsername("guest");
        get.setPassword("");
        get.execute();
        MavenProject p = this.createProjectFromPom(pom);
        List moduleDependencies = p.getOriginalModel().getDependencies();
        if (moduleName.equalsIgnoreCase("root")) {
            this.appfuseProperties = p.getOriginalModel().getProperties();
        }
        LinkedHashSet<String> artifactIds = new LinkedHashSet<String>();
        for (Dependency dep : dependencies) {
            artifactIds.add(dep.getArtifactId());
        }
        for (Object moduleDependency : moduleDependencies) {
            Dependency dep = (Dependency)moduleDependency;
            if (dep.getGroupId().equals("javax.servlet") && dep.getArtifactId().equals("jsp-api") && "jsf".equals(this.project.getProperties().getProperty("web.framework")) || artifactIds.contains(dep.getArtifactId()) || dep.getArtifactId().contains("appfuse")) continue;
            dependencies.add(dep);
        }
        return dependencies;
    }

    private MavenProject createProjectFromPom(File pom) {
        MavenEmbedder maven = new MavenEmbedder();
        maven.setOffline(true);
        maven.setClassLoader(Thread.currentThread().getContextClassLoader());
        maven.setLogger((MavenEmbedderLogger)new MavenEmbedderConsoleLogger());
        MavenProject p = null;
        try {
            maven.setAlignWithUserInstallation(true);
            maven.start();
            p = maven.readProjectWithDependencies(pom);
            maven.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    protected LoadFile createLoadFileTask(String inFile, String propName) {
        LoadFile loadFileTask = (LoadFile)this.antProject.createTask("loadfile");
        loadFileTask.init();
        loadFileTask.setProperty(propName);
        loadFileTask.setSrcFile(new File(inFile));
        return loadFileTask;
    }

    protected void moveFiles(String inSourceDirectory, String inDestinationDirectory, String inPattern) {
        Move moveTask = (Move)this.antProject.createTask("move");
        FileSet fileSet = AntUtils.createFileset(inSourceDirectory, inPattern, new ArrayList());
        moveTask.setTodir(new File(inDestinationDirectory));
        moveTask.addFileset(fileSet);
        moveTask.execute();
    }
}

