/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.mojo.installer;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.appfuse.tool.SubversionUtils;
import org.codehaus.plexus.util.FileUtils;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;

public class CopyTemplatesMojo
extends AbstractMojo {
    private MavenProject project;
    private String trunk;
    private String tag;
    private String templateDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String[] dirs;
        String daoFramework;
        String appfuseVersion = this.project.getProperties().getProperty("appfuse.version");
        if (appfuseVersion != null && !appfuseVersion.endsWith("SNAPSHOT") && this.tag.equals("trunk/")) {
            this.tag = "tags/APPFUSE_" + appfuseVersion.toUpperCase().replaceAll("-", "_") + "/";
        }
        if ((daoFramework = this.project.getProperties().getProperty("dao.framework")) == null) {
            this.log("No dao.framework property specified, defaulting to 'hibernate'");
        }
        String webFramework = this.project.getProperties().getProperty("web.framework");
        boolean modular = this.project.getPackaging().equals("pom") && !this.project.hasParent();
        this.log("Installing templates in " + this.templateDirectory + "...");
        if (!new File(this.templateDirectory).exists()) {
            FileUtils.mkdir((String)this.templateDirectory);
        }
        if (this.project.getPackaging().equals("jar") || this.project.getPackaging().equals("war") && !this.project.hasParent()) {
            this.log("Installing model templates...");
            if (!new File(this.templateDirectory + "/model").exists()) {
                FileUtils.mkdir((String)(this.templateDirectory + "/model"));
            }
            this.export("plugins/appfuse-maven-plugin/src/main/resources/appfuse/model/", (modular ? "core/" + this.templateDirectory : this.templateDirectory) + "/model");
            this.log("Installing " + daoFramework + " templates...");
            if (!new File(this.templateDirectory + "/dao").exists()) {
                FileUtils.mkdir((String)(this.templateDirectory + "/dao"));
            }
            this.export("plugins/appfuse-maven-plugin/src/main/resources/appfuse/dao", (modular ? "core/" + this.templateDirectory : this.templateDirectory) + "/dao");
            try {
                File daoDir = new File(this.templateDirectory + "/dao");
                for (String dir : dirs = daoDir.list()) {
                    if (!new File(this.templateDirectory + "/dao/" + dir).isDirectory() || dir.equals(daoFramework)) continue;
                    FileUtils.deleteDirectory((String)(this.templateDirectory + "/dao/" + dir));
                }
            }
            catch (IOException io) {
                throw new MojoFailureException(io.getMessage());
            }
            this.log("Installing service templates...");
            if (!new File(this.templateDirectory + "/service").exists()) {
                FileUtils.mkdir((String)(this.templateDirectory + "/service"));
            }
            this.export("plugins/appfuse-maven-plugin/src/main/resources/appfuse/service/", (modular ? "core/" + this.templateDirectory : this.templateDirectory) + "/service");
        }
        if (this.project.getPackaging().equalsIgnoreCase("war")) {
            if (webFramework == null) {
                this.getLog().error((CharSequence)"The web.framework property is not specified - please modify your pom.xml to add  this property. For example: <web.framework>struts</web.framework>.");
                throw new MojoExecutionException("No web.framework property specified, please modify pom.xml to add it.");
            }
            this.log("Installing " + webFramework + " templates...");
            if (!new File(this.templateDirectory + "/web").exists()) {
                FileUtils.mkdir((String)(this.templateDirectory + "/web"));
            }
            this.export("plugins/appfuse-maven-plugin/src/main/resources/appfuse/web", (modular ? "web/" + this.templateDirectory : this.templateDirectory) + "/web");
            try {
                File webDir = new File(this.templateDirectory + "/web");
                for (String dir : dirs = webDir.list()) {
                    if (!new File(this.templateDirectory + "/web/" + dir).isDirectory() || dir.equals(webFramework)) continue;
                    FileUtils.deleteDirectory((String)(this.templateDirectory + "/web/" + dir));
                }
            }
            catch (IOException io) {
                throw new MojoFailureException(io.getMessage());
            }
        }
    }

    void setProject(MavenProject project) {
        this.project = project;
    }

    private void export(String url, String destinationDirectory) throws MojoExecutionException {
        SubversionUtils svn = new SubversionUtils(this.trunk + this.tag + url, destinationDirectory);
        try {
            svn.export();
        }
        catch (SVNException e) {
            for (SVNErrorMessage err = e.getErrorMessage(); err != null; err = err.getChildErrorMessage()) {
                this.getLog().error((CharSequence)(err.getErrorCode().getCode() + " : " + err.getMessage()));
            }
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private void log(String msg) {
        this.getLog().info((CharSequence)("[AppFuse] " + msg));
    }
}

