/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.mojo;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.appfuse.mojo.exporter.Component;
import org.codehaus.mojo.hibernate3.ExporterMojo;
import org.codehaus.mojo.hibernate3.HibernateUtils;
import org.codehaus.mojo.hibernate3.configuration.ComponentConfiguration;
import org.hibernate.tool.hbm2x.Exporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HibernateExporterMojo
extends AbstractMojo
implements ExporterMojo {
    private List<Component> components = new ArrayList<Component>();
    private Map<String, Component> defaultComponents = new HashMap<String, Component>();
    private Map<String, String> componentProperties = new HashMap<String, String>();
    private List<ComponentConfiguration> componentConfigurations = new ArrayList<ComponentConfiguration>();
    private MavenProject project;
    private boolean fullSource;

    public boolean isFullSource() {
        return this.fullSource;
    }

    public String getComponentProperty(String key) {
        return this.getComponentProperty(key, null);
    }

    public boolean getComponentProperty(String key, boolean defaultValue) {
        String s = this.getComponentProperty(key);
        if (s == null) {
            return defaultValue;
        }
        return Boolean.valueOf(s);
    }

    public MavenProject getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Thread currentThread = Thread.currentThread();
        ClassLoader oldClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(this.getClassLoader());
            if (this.getComponentProperty("skip", false)) {
                this.getLog().info((CharSequence)"skipping plugin execution");
            } else {
                this.doExecute();
            }
        }
        finally {
            currentThread.setContextClassLoader(oldClassLoader);
        }
    }

    public void addDefaultComponent(String outputDirectory, String implementation, boolean jdk5) {
        Component component = new Component();
        component.setName(this.getName());
        component.setOutputDirectory(outputDirectory);
        component.setImplementation(implementation);
        this.defaultComponents.put(jdk5 ? "jdk15" : "jdk14", component);
    }

    protected Exporter configureExporter(Exporter exporter) throws MojoExecutionException {
        String implementation = this.getComponentProperty("implementation", this.getComponent().getImplementation());
        ComponentConfiguration componentConfiguration = this.getComponentConfiguration(implementation);
        this.getLog().debug((CharSequence)("using " + componentConfiguration.getName() + " task."));
        Properties properties = new Properties();
        properties.putAll(this.componentProperties);
        exporter.setProperties(properties);
        exporter.setConfiguration(componentConfiguration.getConfiguration((ExporterMojo)this));
        exporter.setOutputDirectory(new File(this.getComponent().getOutputDirectory()));
        return exporter;
    }

    public String getComponentProperty(String key, String defaultValue) {
        String value = this.componentProperties.get(key);
        if (value == null || "".equals(value.trim())) {
            return defaultValue;
        }
        return value;
    }

    protected ComponentConfiguration getComponentConfiguration(String name) throws MojoExecutionException {
        for (ComponentConfiguration componentConfiguration : this.componentConfigurations) {
            if (!componentConfiguration.getName().equals(name)) continue;
            return componentConfiguration;
        }
        throw new MojoExecutionException("Could not get ConfigurationTask.");
    }

    protected abstract Exporter createExporter();

    protected void doExecute() throws MojoExecutionException {
        this.configureExporter(this.createExporter()).start();
    }

    private ClassLoader getClassLoader() {
        try {
            List classpathElements = this.project.getCompileClasspathElements();
            classpathElements.add(this.project.getBuild().getOutputDirectory());
            classpathElements.add(this.project.getBuild().getTestOutputDirectory());
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < classpathElements.size(); ++i) {
                urls[i] = new File((String)classpathElements.get(i)).toURL();
            }
            return new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)"Couldn't get the classloader.");
            return ((Object)((Object)this)).getClass().getClassLoader();
        }
    }

    protected Component getComponent() {
        Component defaultGoal = this.defaultComponents.get(HibernateUtils.getJavaVersion());
        if (!this.components.isEmpty()) {
            for (Component component : this.components) {
                if (!this.getName().equals(component.getName())) continue;
                if (component.getImplementation() == null) {
                    component.setImplementation(defaultGoal.getImplementation());
                }
                if (component.getOutputDirectory() == null) {
                    component.setOutputDirectory(defaultGoal.getOutputDirectory());
                }
                return component;
            }
        }
        return defaultGoal;
    }

    public Map<String, String> getComponentProperties() {
        return this.componentProperties;
    }

    void setProject(MavenProject project) {
        this.project = project;
    }
}

