/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.datatypes.Length;
import org.apache.fop.image.FopImage;

public abstract class AbstractFopImage
implements FopImage {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$fop$image$AbstractFopImage == null ? (class$org$apache$fop$image$AbstractFopImage = AbstractFopImage.class$("org.apache.fop.image.AbstractFopImage")) : class$org$apache$fop$image$AbstractFopImage));
    protected int loaded = 0;
    protected int width = 0;
    protected int height = 0;
    protected double dpiHorizontal = 72.0;
    protected double dpiVertical = 72.0;
    protected InputStream inputStream = null;
    protected FopImage.ImageInfo imageInfo = null;
    protected ColorSpace colorSpace = null;
    protected int bitsPerPixel = 0;
    protected byte[] bitmaps = null;
    protected byte[] raw = null;
    protected boolean isTransparent = false;
    protected Color transparentColor = null;
    protected boolean invertImage = false;
    static /* synthetic */ Class class$org$apache$fop$image$AbstractFopImage;

    public AbstractFopImage(FopImage.ImageInfo info) {
        this.inputStream = info.inputStream;
        this.imageInfo = info;
        if (this.imageInfo.width != -1) {
            this.width = this.imageInfo.width;
            this.height = this.imageInfo.height;
            this.dpiHorizontal = this.imageInfo.dpiHorizontal;
            this.dpiVertical = this.imageInfo.dpiVertical;
            this.loaded |= 1;
        }
    }

    public String getMimeType() {
        return this.imageInfo.mimeType;
    }

    public String getOriginalURI() {
        return this.imageInfo.originalURI;
    }

    public synchronized boolean load(int type) {
        if ((this.loaded & type) != 0) {
            return true;
        }
        boolean success = true;
        if ((type & 1) != 0 && (this.loaded & 1) == 0) {
            boolean bl = success = success && this.loadDimensions();
            if (!success) {
                return false;
            }
            this.loaded |= 1;
        }
        if ((type & 4) != 0 && (this.loaded & 4) == 0) {
            boolean bl = success = success && this.loadBitmap();
            if (success) {
                this.loaded |= 4;
            }
        }
        if ((type & 2) != 0 && (this.loaded & 2) == 0) {
            boolean bl = success = success && this.loadOriginalData();
            if (success) {
                this.loaded |= 2;
            }
        }
        return success;
    }

    protected boolean loadDimensions() {
        return false;
    }

    protected boolean loadBitmap() {
        return false;
    }

    protected boolean loadOriginalData() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadDefaultOriginalData() {
        if (this.inputStream == null) {
            throw new IllegalStateException("inputStream is already null or was never set");
        }
        try {
            this.raw = IOUtils.toByteArray((InputStream)this.inputStream);
        }
        catch (IOException ex) {
            log.error((Object)("Error while reading raw image: " + ex.getMessage()), (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.inputStream);
            this.inputStream = null;
        }
        return true;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getIntrinsicWidth() {
        return (int)((double)(this.getWidth() * 72000) / this.getHorizontalResolution());
    }

    public int getIntrinsicHeight() {
        return (int)((double)(this.getHeight() * 72000) / this.getVerticalResolution());
    }

    public Length getIntrinsicAlignmentAdjust() {
        return this.imageInfo.alignmentAdjust;
    }

    public double getHorizontalResolution() {
        return this.dpiHorizontal;
    }

    public double getVerticalResolution() {
        return this.dpiVertical;
    }

    public ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public ICC_Profile getICCProfile() {
        if (this.colorSpace != null && this.colorSpace instanceof ICC_ColorSpace) {
            return ((ICC_ColorSpace)this.colorSpace).getProfile();
        }
        return null;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public boolean isTransparent() {
        return this.isTransparent;
    }

    public boolean hasSoftMask() {
        return false;
    }

    public byte[] getSoftMask() {
        return null;
    }

    public Color getTransparentColor() {
        return this.transparentColor;
    }

    public boolean isInverted() {
        return this.invertImage;
    }

    public byte[] getBitmaps() {
        return this.bitmaps;
    }

    public int getBitmapsSize() {
        return this.bitmaps != null ? this.bitmaps.length : 0;
    }

    public byte[] getRessourceBytes() {
        return this.raw;
    }

    public int getRessourceBytesSize() {
        return this.raw != null ? this.raw.length : 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

