/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.process.conf;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.RepositoryService;
import org.activiti.spring.process.ProcessExtensionService;
import org.activiti.spring.process.ProcessVariablesInitiator;
import org.activiti.spring.process.model.ProcessExtensionModel;
import org.activiti.spring.process.variable.DateFormatterProvider;
import org.activiti.spring.process.variable.VariableParsingService;
import org.activiti.spring.process.variable.VariableValidationService;
import org.activiti.spring.process.variable.types.DateVariableType;
import org.activiti.spring.process.variable.types.JavaObjectVariableType;
import org.activiti.spring.process.variable.types.JsonObjectVariableType;
import org.activiti.spring.process.variable.types.VariableType;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.ResourcePatternResolver;

@Configuration
public class ProcessExtensionsAutoConfiguration {
    @Bean
    public ProcessVariablesInitiator processVariablesInitiator(ProcessExtensionService processExtensionService, VariableParsingService variableParsingService, VariableValidationService variableValidationService) {
        return new ProcessVariablesInitiator(processExtensionService, variableParsingService, variableValidationService);
    }

    @Bean
    public Map<String, ProcessExtensionModel> processExtensionsMap(ProcessExtensionService processExtensionService) throws IOException {
        return processExtensionService.readProcessExtensions();
    }

    @Bean
    public ProcessExtensionService processExtensionService(@Value(value="${activiti.process.extensions.dir:classpath:/processes/}") String processExtensionsRoot, @Value(value="${activiti.process.extensions.suffix:**-extensions.json}") String processExtensionsSuffix, ObjectMapper objectMapper, ResourcePatternResolver resourceLoader, Map<String, VariableType> variableTypeMap) {
        return new ProcessExtensionService(processExtensionsRoot, processExtensionsSuffix, objectMapper, resourceLoader, variableTypeMap);
    }

    @Bean
    InitializingBean initRepositoryServiceForProcessExtensionService(RepositoryService repositoryService, ProcessExtensionService processExtensionService) {
        return () -> processExtensionService.setRepositoryService(repositoryService);
    }

    @Bean
    @ConditionalOnMissingBean
    public DateFormatterProvider dateFormatterProvider(@Value(value="${spring.activiti.date-format-pattern:yyyy-MM-dd[['T'][ ]HH:mm:ss[.SSS'Z']]}") String dateFormatPattern) {
        return new DateFormatterProvider(dateFormatPattern);
    }

    @Bean
    public Map<String, VariableType> variableTypeMap(ObjectMapper objectMapper, DateFormatterProvider dateFormatterProvider) {
        HashMap<String, VariableType> variableTypeMap = new HashMap<String, VariableType>();
        variableTypeMap.put("boolean", new JavaObjectVariableType(Boolean.class));
        variableTypeMap.put("string", new JavaObjectVariableType(String.class));
        variableTypeMap.put("integer", new JavaObjectVariableType(Integer.class));
        variableTypeMap.put("json", new JsonObjectVariableType(objectMapper));
        variableTypeMap.put("file", new JsonObjectVariableType(objectMapper));
        variableTypeMap.put("date", new DateVariableType(Date.class, dateFormatterProvider));
        return variableTypeMap;
    }

    @Bean
    public VariableValidationService variableValidationService(Map<String, VariableType> variableTypeMap) {
        return new VariableValidationService(variableTypeMap);
    }

    @Bean
    public VariableParsingService variableParsingService(Map<String, VariableType> variableTypeMap) {
        return new VariableParsingService(variableTypeMap);
    }
}

