/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.workflow.simple.definition;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.activiti.workflow.simple.definition.AbstractNamedStepDefinition;
import org.activiti.workflow.simple.definition.FormStepDefinition;
import org.activiti.workflow.simple.definition.HumanStepAssignment;
import org.activiti.workflow.simple.definition.StepDefinition;
import org.activiti.workflow.simple.definition.form.FormDefinition;
import org.activiti.workflow.simple.exception.SimpleWorkflowException;

@JsonTypeName(value="human-step")
public class HumanStepDefinition
extends AbstractNamedStepDefinition
implements FormStepDefinition {
    private static final long serialVersionUID = 1L;
    protected FormDefinition form;
    protected HumanStepAssignment assignment;

    @JsonIgnore
    public HumanStepAssignment.HumanStepAssignmentType getAssignmentType() {
        return this.ensureAssignment().getType();
    }

    public String getAssignee() {
        return this.ensureAssignment().getAssignee();
    }

    public HumanStepDefinition setAssignee(String assignee) {
        this.ensureAssignment().setAssignee(assignee);
        return this;
    }

    public List<String> getCandidateUsers() {
        return this.ensureAssignment().getCandidateUsers();
    }

    public HumanStepDefinition setCandidateUsers(List<String> candidateUsers) {
        this.ensureAssignment().setCandidateUsers(candidateUsers);
        return this;
    }

    public List<String> getCandidateGroups() {
        return this.ensureAssignment().getCandidateGroups();
    }

    public HumanStepDefinition setCandidateGroups(List<String> candidateGroups) {
        this.ensureAssignment().setCandidateGroups(candidateGroups);
        return this;
    }

    @Override
    public FormDefinition getForm() {
        return this.form;
    }

    public HumanStepDefinition addForm(FormDefinition form) {
        this.form = form;
        return this;
    }

    @Override
    public void setForm(FormDefinition form) {
        this.form = form;
    }

    public HumanStepAssignment getAssignment() {
        return this.ensureAssignment();
    }

    public void setAssignment(HumanStepAssignment assignment) {
        this.assignment = assignment;
    }

    protected HumanStepAssignment ensureAssignment() {
        if (this.assignment == null) {
            this.assignment = new HumanStepAssignment();
        }
        return this.assignment;
    }

    @Override
    public StepDefinition clone() {
        HumanStepDefinition clone = new HumanStepDefinition();
        clone.setValues(this);
        return clone;
    }

    @Override
    public void setValues(StepDefinition otherDefinition) {
        if (!(otherDefinition instanceof HumanStepDefinition)) {
            throw new SimpleWorkflowException("An instance of HumanStepDefinition is required to set values");
        }
        HumanStepDefinition stepDefinition = (HumanStepDefinition)otherDefinition;
        this.setAssignee(stepDefinition.getAssignee());
        if (stepDefinition.getCandidateGroups() != null && !stepDefinition.getCandidateGroups().isEmpty()) {
            this.setCandidateGroups(new ArrayList<String>(stepDefinition.getCandidateGroups()));
        }
        if (stepDefinition.getCandidateUsers() != null && !stepDefinition.getCandidateUsers().isEmpty()) {
            this.setCandidateUsers(new ArrayList<String>(stepDefinition.getCandidateUsers()));
        }
        this.setDescription(stepDefinition.getDescription());
        if (stepDefinition.getForm() != null) {
            this.setForm(stepDefinition.getForm().clone());
        } else {
            this.setForm(null);
        }
        this.setId(stepDefinition.getId());
        this.setName(stepDefinition.getName());
        this.setStartsWithPrevious(stepDefinition.isStartsWithPrevious());
        this.getAssignment().setType(stepDefinition.getAssignmentType());
        this.setParameters(new HashMap<String, Object>(otherDefinition.getParameters()));
    }
}

