/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitytest.blueprint.strategy.matching;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.Check;
import net.sf.qualitytest.blueprint.MatchingStrategy;

public class BuilderMethodMatchingStrategy
implements MatchingStrategy {
    private static final String BUILDER_SUFFIX = "Builder";
    private final String builderSuffix;

    public BuilderMethodMatchingStrategy() {
        this.builderSuffix = BUILDER_SUFFIX;
    }

    public BuilderMethodMatchingStrategy(@Nonnull String suffix) {
        this.builderSuffix = (String)Check.notNull((Object)suffix, (String)"suffix");
    }

    @Override
    public boolean matchesByField(Field field) {
        return false;
    }

    @Override
    public boolean matchesByMethod(Method method) {
        Check.notNull((Object)method, (String)"method");
        boolean takesOneParameter = method.getParameterTypes().length == 1;
        boolean isOnBuilder = method.getDeclaringClass().getName().endsWith(this.builderSuffix);
        return takesOneParameter && isOnBuilder;
    }

    @Override
    public boolean matchesByType(Class<?> clazz) {
        return false;
    }
}

