/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitytest.blueprint.strategy.creation;

import java.lang.reflect.Array;
import net.sf.qualitycheck.Check;
import net.sf.qualitytest.blueprint.Blueprint;
import net.sf.qualitytest.blueprint.BlueprintConfiguration;
import net.sf.qualitytest.blueprint.BlueprintSession;
import net.sf.qualitytest.blueprint.CreationStrategy;

public class DefaultArrayCreationStrategy
implements CreationStrategy<Object> {
    public static final int DEFAULT_LENGTH = 7;
    private final int length;

    private static <T> void initializeArray(Class<T> array, int arraySize, Object value, BlueprintConfiguration config, BlueprintSession session) {
        for (int i = 0; i < arraySize; ++i) {
            Object blueprint = Blueprint.construct(array.getComponentType(), config, session);
            Array.set(value, i, blueprint);
        }
    }

    public DefaultArrayCreationStrategy(int length) {
        this.length = length;
    }

    @Override
    public Object createValue(Class<?> expectedClass, BlueprintConfiguration config, BlueprintSession session) {
        Check.notNull(expectedClass, (String)"expectedClass");
        Object value = Array.newInstance(expectedClass.getComponentType(), this.length);
        if (!expectedClass.getComponentType().isPrimitive()) {
            DefaultArrayCreationStrategy.initializeArray(expectedClass, this.length, value, config, session);
        }
        return value;
    }
}

