/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.people.action.people;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.digest.DigestUtil;
import freemarker.core.ParseException;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.TemplateNotFoundException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.constant.e.BaseCookieEnum;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.mdiy.biz.IPageBiz;
import net.mingsoft.mdiy.entity.PageEntity;
import net.mingsoft.mdiy.util.ParserUtil;
import net.mingsoft.people.action.BaseAction;
import net.mingsoft.people.biz.IPeopleBiz;
import net.mingsoft.people.constant.ModelCode;
import net.mingsoft.people.constant.e.CookieConstEnum;
import net.mingsoft.people.constant.e.PeopleEnum;
import net.mingsoft.people.entity.PeopleEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u7528\u6237\u57fa\u7840\u4fe1\u606f\u63a5\u53e3(\u9700\u7528\u6237\u767b\u5f55)")
@Controller(value="peopleMain")
@RequestMapping(value={"/people"})
public class PeopleAction
extends BaseAction {
    @Autowired
    private IPeopleBiz peopleBiz;
    @Autowired
    private IPageBiz pageBiz;

    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801\u63a5\u53e3")
    @ApiImplicitParam(name="peoplePassword", value="\u7528\u6237\u5bc6\u7801", required=true, paramType="query")
    @PostMapping(value={"/resetPassword"})
    @ResponseBody
    public void resetPassword(@ModelAttribute @ApiIgnore PeopleEntity people, HttpServletRequest request, HttpServletResponse response) {
        if (!StringUtil.checkLength((String)people.getPeoplePassword(), (int)6, (int)30)) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("err.length", this.getResString("people.password"), "6", "20"));
            return;
        }
        if (StringUtils.isBlank((CharSequence)people.getPeoplePassword())) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("err.empty", this.getResString("people.password")));
            return;
        }
        PeopleEntity _people = (PeopleEntity)this.peopleBiz.getEntity(this.getPeopleBySession().getPeopleId());
        String peoplePassWord = DigestUtil.md5Hex((String)people.getPeoplePassword(), (String)"utf-8");
        _people.setPeoplePassword(peoplePassWord);
        this.peopleBiz.updateEntity((BaseEntity)_people);
        this.outJson(response, ModelCode.PEOPLE, true);
    }

    @PostMapping(value={"/changePassword"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="peoplePassword", value="\u7528\u6237\u5bc6\u7801", required=true, paramType="query"), @ApiImplicitParam(name="peopleOldPassword", value="\u7528\u6237\u65e7\u5bc6\u7801", required=true, paramType="query")})
    @ResponseBody
    public void changePassword(@ModelAttribute @ApiIgnore PeopleEntity people, HttpServletRequest request, HttpServletResponse response) {
        if (!this.checkRandCode(request)) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("err.error", this.getResString("rand.code")));
            return;
        }
        if (StringUtils.isBlank((CharSequence)people.getPeoplePassword())) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("err.empty", this.getResString("people.password")));
            return;
        }
        if (StringUtils.isBlank((CharSequence)people.getPeoplePassword())) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("err.empty", this.getResString("people.password")));
            return;
        }
        if (!StringUtil.checkLength((String)people.getPeoplePassword(), (int)6, (int)30)) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("err.length", this.getResString("people.password"), "6", "20"));
            return;
        }
        if (people.getPeoplePassword().contains(" ")) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("people.password") + this.getResString("people.space"));
            return;
        }
        PeopleEntity _people = new PeopleEntity();
        _people.setPeopleId(this.getPeopleBySession().getPeopleId());
        PeopleEntity curPeople = (PeopleEntity)((Object)this.peopleBiz.getEntity((BaseEntity)_people));
        if (!curPeople.isNewUser() && StringUtils.isBlank((CharSequence)people.getPeopleOldPassword())) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("err.empty", this.getResString("people.old.password")));
            return;
        }
        if (!curPeople.isNewUser() && !curPeople.getPeoplePassword().equals(SecureUtil.md5((String)people.getPeopleOldPassword()))) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("err.error", this.getResString("people.password")));
            return;
        }
        String peoplePassWord = DigestUtil.md5Hex((String)people.getPeoplePassword(), (String)"utf-8");
        curPeople.setPeoplePassword(peoplePassWord);
        this.peopleBiz.updateEntity((BaseEntity)curPeople);
        this.outJson(response, ModelCode.PEOPLE, true);
    }

    @ApiOperation(value="\u4fee\u6539\u624b\u673a\u53f7\u63a5\u53e3")
    @PostMapping(value={"/changePhone"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="peoplePassword", value="\u7528\u6237\u5bc6\u7801", required=true, paramType="query"), @ApiImplicitParam(name="peopleCode", value="\u624b\u673a\u9a8c\u8bc1\u7801", required=true, paramType="query")})
    @ResponseBody
    public void changePhone(@ModelAttribute @ApiIgnore PeopleEntity people, HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity _people = this.getPeopleBySession();
        if (StringUtils.isBlank((CharSequence)people.getPeoplePhone())) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("err.empty", this.getResString("people.phone")));
            return;
        }
        if (_people.getPeoplePhoneCheck() == PeopleEnum.PHONE_CHECK.toInt()) {
            PeopleEntity tempPeople = this.peopleBiz.getByPeople(people, BasicUtil.getAppId());
            if (!people.getPeopleCode().equals(tempPeople.getPeopleCode())) {
                this.outJson(response, ModelCode.PEOPLE_REGISTER, false, this.getResString("err.error", this.getResString("people.phone.code")));
                return;
            }
        }
        people.setPeoplePhone(people.getPeoplePhone());
        this.peopleBiz.updateEntity((BaseEntity)people);
        this.outJson(response, ModelCode.PEOPLE, true);
    }

    @ApiOperation(value="\u9a8c\u8bc1\u7528\u6237\u77ed\u4fe1\u3001\u90ae\u7bb1\u9a8c\u8bc1\u7801\u662f\u5426\u6b63\u786e\u63a5\u53e3")
    @ApiImplicitParam(name="peopleCode", value="\u624b\u673a\u9a8c\u8bc1\u7801", required=true, paramType="query")
    @PostMapping(value={"/checkPeopleCode"})
    @ResponseBody
    public void checkPeopleCode(@ModelAttribute @ApiIgnore PeopleEntity people, HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity _people = this.getPeopleBySession();
        PeopleEntity _temp = this.peopleBiz.getByPeople(_people, BasicUtil.getAppId());
        if (people.getPeopleCode().equals(_temp.getPeopleCode())) {
            this.outJson(response, ModelCode.PEOPLE, true);
        } else {
            this.outJson(response, ModelCode.PEOPLE, false);
        }
    }

    @ApiOperation(value="\u8bfb\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u57fa\u672c\u4fe1\u606f \u7528\u6237\u4fe1\u606f\u63a5\u53e3")
    @GetMapping(value={"/info"})
    @ResponseBody
    public void info(HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity people = this.getPeopleBySession();
        this.outJson(response, (Object)people, new String[]{"peopleOldPassword", "peoplePassword"});
    }

    @ApiOperation(value="\u9000\u51fa\u767b\u5f55\u63a5\u53e3")
    @GetMapping(value={"/quit"})
    @ResponseBody
    public void quit(HttpServletRequest request, HttpServletResponse response) {
        this.removePeopleBySession(request);
        BasicUtil.setCookie((HttpServletResponse)response, (BaseCookieEnum)CookieConstEnum.PEOPLE_COOKIE, null);
        this.outJson(response, true);
    }

    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u90ae\u7bb1\u6216\u624b\u673a\u53f7\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="peopleMail", value="\u7528\u6237\u90ae\u7bb1", required=false, paramType="query"), @ApiImplicitParam(name="peoplePhone", value="\u624b\u673a\u53f7", required=false, paramType="query")})
    @PostMapping(value={"/update"})
    public void update(@ModelAttribute @ApiIgnore PeopleEntity people, HttpServletRequest request, HttpServletResponse response) {
        if (people == null) {
            this.outJson(response, ModelCode.PEOPLE, false, this.getResString("err.empty", this.getResString("people")));
            return;
        }
        int peopleId = this.getPeopleBySession().getPeopleId();
        PeopleEntity _people = (PeopleEntity)this.peopleBiz.getEntity(peopleId);
        if (_people.getPeopleMailCheck() == PeopleEnum.MAIL_CHECK.toInt()) {
            people.setPeopleMail(null);
        }
        if (_people.getPeoplePhoneCheck() == PeopleEnum.PHONE_CHECK.toInt()) {
            people.setPeoplePhone(null);
        }
        people.setPeopleName(null);
        people.setPeopleId(peopleId);
        this.peopleBiz.updateEntity((BaseEntity)people);
        this.outJson(response, ModelCode.PEOPLE, true, this.getResString("success"));
    }

    @ApiOperation(value="\u524d\u7aef\u4f1a\u5458\u4e2d\u5fc3\u6240\u6709\u9875\u9762\u90fd\u53ef\u4ee5\u4f7f\u7528\u8be5\u65b9\u6cd5 \u652f\u6301\u53c2\u6570\u4f20\u9012\u4e0e\u89e3\u6790\uff0c\u4f8b\u5982\u9875\u9762\u4e2d\u6709\u53c2\u6570id=10 \u4f20\u9012\u8fc7\u6765\uff0c\u8df3\u8f6c\u9875\u9762\u53ef\u4ee5\u4f7f\u7528{id/}\u83b7\u53d6\u8be5\u53c2\u6570")
    @ApiImplicitParam(name="diy", value="id", required=true, paramType="path")
    @GetMapping(value={"/{diy}"})
    public void diy(@PathVariable(value="diy") String diy, HttpServletRequest req, HttpServletResponse resp) {
        Map map = BasicUtil.assemblyRequestMap();
        map.put("isDo", true);
        map.put("modelName", "mcms");
        map.put("url", BasicUtil.getUrl());
        String content = "";
        PageEntity page = new PageEntity();
        page.setPageKey("people/" + diy);
        PageEntity _page = (PageEntity)this.pageBiz.getEntity((BaseEntity)page);
        if (ObjectUtil.isNull((Object)_page)) {
            this.outJson(resp, false, this.getResString("templet.file"));
            return;
        }
        try {
            content = ParserUtil.generate((String)_page.getPagePath(), (Map)map, (boolean)this.isMobileDevice(req));
        }
        catch (TemplateNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedTemplateNameException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.outString(resp, content);
    }
}

