/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.server.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.sms.core.domain.NoticeData;
import net.guerlab.sms.core.exception.NotFindSendHandlerException;
import net.guerlab.sms.core.handler.SendHandler;
import net.guerlab.sms.server.properties.SmsProperties;
import net.guerlab.sms.server.service.NoticeService;
import net.guerlab.spring.commons.util.SpringApplicationContextUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultNoticeService
implements NoticeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultNoticeService.class);
    @Autowired
    private SmsProperties properties;

    @Override
    public boolean phoneRegValidation(String phone) {
        return StringUtils.isNotBlank((CharSequence)phone) && (StringUtils.isBlank((CharSequence)this.properties.getReg()) || phone.matches(this.properties.getReg()));
    }

    @Override
    public boolean send(NoticeData noticeData, Collection<String> phones) {
        if (noticeData == null) {
            LOGGER.debug("noticeData is null");
            return false;
        }
        if (CollectionUtil.isEmpty(phones)) {
            LOGGER.debug("phones is empty");
            return false;
        }
        List phoneList = phones.stream().filter(this::phoneRegValidation).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(phoneList)) {
            LOGGER.debug("filted phones is empty");
            return false;
        }
        Map sendHandlerMap = SpringApplicationContextUtil.getContext().getBeansOfType(SendHandler.class);
        if (sendHandlerMap.isEmpty()) {
            throw new NotFindSendHandlerException();
        }
        Optional optional = sendHandlerMap.values().stream().findAny();
        if (optional.isPresent()) {
            return ((SendHandler)optional.get()).send(noticeData, phones);
        }
        return false;
    }
}

