/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.server.autoconfigure;

import java.lang.reflect.Method;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.sms.core.domain.NoticeInfo;
import net.guerlab.sms.core.domain.VerifyInfo;
import net.guerlab.sms.server.controller.SmsController;
import net.guerlab.sms.server.properties.SmsProperties;
import net.guerlab.sms.server.properties.SmsWebProperties;
import net.guerlab.sms.server.repository.IVerificationCodeRepository;
import net.guerlab.sms.server.repository.VerificationCodeMemoryRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@EnableConfigurationProperties(value={SmsProperties.class})
@ComponentScan(value={"net.guerlab.sms.server.controller", "net.guerlab.sms.server.repository", "net.guerlab.sms.server.service"})
public class SmsConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={IVerificationCodeRepository.class})
    public IVerificationCodeRepository verificationCodeMemoryRepository() {
        return new VerificationCodeMemoryRepository();
    }

    @Autowired
    public void setWebMapping(RequestMappingHandlerMapping mapping, SmsProperties smsProperties, SmsController controller) {
        if (smsProperties.getWeb() == null || !smsProperties.getWeb().isEnable()) {
            return;
        }
        Method sendMethod = null;
        Method getMethod = null;
        Method verifyMethod = null;
        Method noticeMethod = null;
        try {
            sendMethod = SmsController.class.getMethod("sendVerificationCode", String.class);
            getMethod = SmsController.class.getMethod("getVerificationCode", String.class, String.class);
            verifyMethod = SmsController.class.getMethod("verifyVerificationCode", VerifyInfo.class);
            noticeMethod = SmsController.class.getMethod("sendNotice", NoticeInfo.class);
        }
        catch (Exception e) {
            throw new ApplicationException(e.getLocalizedMessage(), (Throwable)e);
        }
        String bathPath = this.getBasePath(smsProperties);
        RequestMappingInfo sendInfo = RequestMappingInfo.paths((String[])new String[]{bathPath + "/verificationCode/{phone}"}).methods(new RequestMethod[]{RequestMethod.POST}).build();
        RequestMappingInfo getInfo = RequestMappingInfo.paths((String[])new String[]{bathPath + "/verificationCode/{phone}"}).methods(new RequestMethod[]{RequestMethod.GET}).produces(new String[]{"application/json"}).build();
        RequestMappingInfo verifyInfo = RequestMappingInfo.paths((String[])new String[]{bathPath + "/verificationCode"}).methods(new RequestMethod[]{RequestMethod.POST}).build();
        RequestMappingInfo noticeInfo = RequestMappingInfo.paths((String[])new String[]{bathPath + "/notice"}).methods(new RequestMethod[]{RequestMethod.PUT}).build();
        mapping.registerMapping((Object)sendInfo, (Object)controller, sendMethod);
        mapping.registerMapping((Object)getInfo, (Object)controller, getMethod);
        mapping.registerMapping((Object)verifyInfo, (Object)controller, verifyMethod);
        mapping.registerMapping((Object)noticeInfo, (Object)controller, noticeMethod);
    }

    private String getBasePath(SmsProperties smsProperties) {
        SmsWebProperties properties = smsProperties.getWeb();
        if (properties == null) {
            return "/sms";
        }
        String bathPath = properties.getBasePath();
        if (StringUtils.isBlank((CharSequence)bathPath)) {
            return "/sms";
        }
        return bathPath.trim();
    }
}

