/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.http;

import java.io.IOException;
import java.util.HashMap;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.Utf8ResponseHandler;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.mp.bean.WxMpMaterialNews;
import me.chanjar.weixin.mp.util.json.WxMpGsonBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class MaterialNewsInfoRequestExecutor
implements RequestExecutor<WxMpMaterialNews, String> {
    public WxMpMaterialNews execute(CloseableHttpClient httpclient, HttpHost httpProxy, String uri, String materialId) throws WxErrorException, ClientProtocolException, IOException {
        HttpPost httpPost = new HttpPost(uri);
        if (httpProxy != null) {
            RequestConfig config = RequestConfig.custom().setProxy(httpProxy).build();
            httpPost.setConfig(config);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("media_id", materialId);
        httpPost.setEntity((HttpEntity)new StringEntity(WxGsonBuilder.create().toJson(params)));
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
        String responseContent = (String)Utf8ResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
        WxError error = WxError.fromJson((String)responseContent);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return (WxMpMaterialNews)WxMpGsonBuilder.create().fromJson(responseContent, WxMpMaterialNews.class);
    }
}

