/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.web;

import brave.Span;
import brave.Tracing;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public final class TracingClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    final CurrentTraceContext currentTraceContext;
    final HttpClientHandler<brave.http.HttpClientRequest, brave.http.HttpClientResponse> handler;

    public static ClientHttpRequestInterceptor create(Tracing tracing) {
        return TracingClientHttpRequestInterceptor.create(HttpTracing.create((Tracing)tracing));
    }

    public static ClientHttpRequestInterceptor create(HttpTracing httpTracing) {
        return new TracingClientHttpRequestInterceptor(httpTracing);
    }

    @Autowired
    TracingClientHttpRequestInterceptor(HttpTracing httpTracing) {
        this.currentTraceContext = httpTracing.tracing().currentTraceContext();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing);
    }

    /*
     * Loose catch block
     */
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        ClientHttpResponse clientHttpResponse;
        CurrentTraceContext.Scope ws;
        Throwable error;
        HttpClientResponse response;
        Span span;
        block10: {
            span = this.handler.handleSend((brave.http.HttpClientRequest)new HttpClientRequest(request));
            response = null;
            error = null;
            ws = this.currentTraceContext.newScope(span.context());
            ClientHttpResponse result = execution.execute(request, body);
            response = new HttpClientResponse(result);
            clientHttpResponse = result;
            if (ws == null) break block10;
            ws.close();
        }
        this.handler.handleReceive((Object)response, error, span);
        return clientHttpResponse;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (ws != null) {
                            try {
                                ws.close();
                            }
                            catch (Throwable throwable2) {
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | Error | RuntimeException e) {
                        error = e;
                        throw e;
                    }
                }
                catch (Throwable throwable3) {
                    this.handler.handleReceive(response, error, span);
                    throw throwable3;
                }
            }
        }
    }

    static final class HttpClientRequest
    extends brave.http.HttpClientRequest {
        final HttpRequest delegate;

        HttpClientRequest(HttpRequest delegate) {
            this.delegate = delegate;
        }

        public Object unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.getMethod().name();
        }

        public String path() {
            return this.delegate.getURI().getPath();
        }

        public String url() {
            return this.delegate.getURI().toString();
        }

        public String header(String name) {
            String result = this.delegate.getHeaders().getFirst(name);
            return result instanceof String ? result.toString() : null;
        }

        public void header(String name, String value) {
            this.delegate.getHeaders().set(name, value);
        }
    }

    static final class HttpClientResponse
    extends brave.http.HttpClientResponse {
        final ClientHttpResponse delegate;

        HttpClientResponse(ClientHttpResponse delegate) {
            this.delegate = delegate;
        }

        public Object unwrap() {
            return this.delegate;
        }

        public int statusCode() {
            try {
                return this.delegate.getRawStatusCode();
            }
            catch (IOException | IllegalArgumentException e) {
                return 0;
            }
        }
    }
}

