/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.web;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.propagation.TraceContext;
import brave.spring.web.TracingClientHttpRequestInterceptor;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.AsyncClientHttpRequestExecution;
import org.springframework.http.client.AsyncClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

public final class TracingAsyncClientHttpRequestInterceptor
implements AsyncClientHttpRequestInterceptor {
    final Tracer tracer;
    final HttpClientHandler<HttpRequest, ClientHttpResponse> handler;
    final TraceContext.Injector<HttpHeaders> injector;

    public static AsyncClientHttpRequestInterceptor create(Tracing tracing) {
        return TracingAsyncClientHttpRequestInterceptor.create(HttpTracing.create((Tracing)tracing));
    }

    public static AsyncClientHttpRequestInterceptor create(HttpTracing httpTracing) {
        return new TracingAsyncClientHttpRequestInterceptor(httpTracing);
    }

    @Autowired
    TracingAsyncClientHttpRequestInterceptor(HttpTracing httpTracing) {
        this.tracer = httpTracing.tracing().tracer();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing, (HttpClientAdapter)new TracingClientHttpRequestInterceptor.HttpAdapter());
        this.injector = httpTracing.tracing().propagation().injector(TracingClientHttpRequestInterceptor.SETTER);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListenableFuture<ClientHttpResponse> intercept(HttpRequest request, byte[] body, AsyncClientHttpRequestExecution execution) throws IOException {
        Span span = this.handler.handleSend(this.injector, (Object)request.getHeaders(), (Object)request);
        try {
            Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
            Throwable throwable = null;
            try {
                ListenableFuture result = execution.executeAsync(request, body);
                result.addCallback((ListenableFutureCallback)new TraceListenableFutureCallback(span, this.handler));
                ListenableFuture listenableFuture = result;
                return listenableFuture;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ws != null) {
                    if (throwable != null) {
                        try {
                            ws.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        ws.close();
                    }
                }
            }
        }
        catch (IOException | Error | RuntimeException e) {
            this.handler.handleReceive(null, e, span);
            throw e;
        }
    }

    static final class TraceListenableFutureCallback
    implements ListenableFutureCallback<ClientHttpResponse> {
        final Span span;
        final HttpClientHandler<HttpRequest, ClientHttpResponse> handler;

        TraceListenableFutureCallback(Span span, HttpClientHandler<HttpRequest, ClientHttpResponse> handler) {
            this.span = span;
            this.handler = handler;
        }

        public void onFailure(Throwable ex) {
            this.handler.handleReceive(null, ex, this.span);
        }

        public void onSuccess(ClientHttpResponse result) {
            this.handler.handleReceive((Object)result, null, this.span);
        }
    }
}

