/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import java.net.InetSocketAddress;
import reactor.netty.http.server.ConnectionInfo;
import reactor.netty.tcp.InetSocketAddressUtil;

final class HAProxyMessageReader
extends ChannelInboundHandlerAdapter {
    private static final boolean hasProxyProtocol;

    HAProxyMessageReader() {
    }

    public static boolean hasProxyProtocol() {
        return hasProxyProtocol;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HAProxyMessage) {
            HAProxyMessage proxyMessage = (HAProxyMessage)msg;
            if (proxyMessage.sourceAddress() != null && proxyMessage.sourcePort() != 0) {
                InetSocketAddress remoteAddress = InetSocketAddressUtil.createUnresolved(proxyMessage.sourceAddress(), proxyMessage.sourcePort());
                ctx.channel().attr(ConnectionInfo.REMOTE_ADDRESS_FROM_PROXY_PROTOCOL).set((Object)remoteAddress);
            }
            ctx.channel().pipeline().remove((ChannelHandler)this);
            ctx.read();
        } else {
            super.channelRead(ctx, msg);
        }
    }

    static {
        boolean proxyProtocolCheck = true;
        try {
            Class.forName("io.netty.handler.codec.haproxy.HAProxyMessageDecoder");
        }
        catch (ClassNotFoundException cnfe) {
            proxyProtocolCheck = false;
        }
        hasProxyProtocol = proxyProtocolCheck;
    }
}

