/*
 * Decompiled with CFR 0.152.
 */
package com.excel.poi.factory;

import com.excel.poi.annotation.ExportField;
import com.excel.poi.annotation.ImportField;
import com.excel.poi.entity.ExcelEntity;
import com.excel.poi.entity.ExcelPropertyEntity;
import com.excel.poi.exception.ExcelBootException;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class ExcelMappingFactory {
    public static ExcelEntity loadImportExcelClass(Class clazz) {
        Field[] fields;
        ArrayList<ExcelPropertyEntity> propertyList = new ArrayList<ExcelPropertyEntity>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            ImportField importField = field.getAnnotation(ImportField.class);
            if (null == importField) continue;
            field.setAccessible(true);
            ExcelPropertyEntity excelPropertyEntity = ExcelPropertyEntity.builder().fieldEntity(field).required(importField.required()).dateFormat(importField.dateFormat().trim()).regex(importField.regex().trim()).regexMessage(importField.regexMessage().trim()).scale(importField.scale()).roundingMode(importField.roundingMode()).build();
            propertyList.add(excelPropertyEntity);
        }
        if (propertyList.isEmpty()) {
            throw new ExcelBootException("[{}] \u7c7b\u672a\u627e\u5230\u6807\u6ce8@ImportField\u6ce8\u89e3\u7684\u5c5e\u6027!", clazz.getName());
        }
        ExcelEntity excelMapping = new ExcelEntity();
        excelMapping.setPropertyList(propertyList);
        return excelMapping;
    }

    public static ExcelEntity loadExportExcelClass(Class<?> clazz, String fileName) {
        Field[] fields;
        ArrayList<ExcelPropertyEntity> propertyList = new ArrayList<ExcelPropertyEntity>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            ExportField exportField = field.getAnnotation(ExportField.class);
            if (null == exportField) continue;
            field.setAccessible(true);
            ExcelPropertyEntity excelPropertyEntity = ExcelPropertyEntity.builder().fieldEntity(field).columnName(exportField.columnName().trim()).scale(exportField.scale()).roundingMode(exportField.roundingMode()).dateFormat(exportField.dateFormat().trim()).templateCellValue(exportField.defaultCellValue().trim()).build();
            propertyList.add(excelPropertyEntity);
        }
        if (propertyList.isEmpty()) {
            throw new ExcelBootException("[{}]\u7c7b\u672a\u627e\u5230\u6807\u6ce8@ExportField\u6ce8\u89e3\u7684\u5c5e\u6027!", clazz.getName());
        }
        ExcelEntity excelMapping = new ExcelEntity();
        excelMapping.setPropertyList(propertyList);
        excelMapping.setFileName(fileName);
        return excelMapping;
    }
}

